package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  EnvironmentProfileId,
  ProjectId,
  DomainId,
  PaginationToken,
  EnvironmentBlueprintId,
  MaxResults,
  AwsRegion,
  AwsAccountId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEnvironmentsRequest(
    awsAccountId: Optional[AwsAccountId] = Optional.Absent,
    awsAccountRegion: Optional[AwsRegion] = Optional.Absent,
    domainIdentifier: DomainId,
    environmentBlueprintIdentifier: Optional[EnvironmentBlueprintId] =
      Optional.Absent,
    environmentProfileIdentifier: Optional[EnvironmentProfileId] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    projectIdentifier: ProjectId,
    provider: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.EnvironmentStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest = {
    import ListEnvironmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest
      .builder()
      .optionallyWith(
        awsAccountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        awsAccountRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsAccountRegion)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        environmentBlueprintIdentifier.map(value =>
          EnvironmentBlueprintId.unwrap(value): java.lang.String
        )
      )(_.environmentBlueprintIdentifier)
      .optionallyWith(
        environmentProfileIdentifier.map(value =>
          EnvironmentProfileId.unwrap(value): java.lang.String
        )
      )(_.environmentProfileIdentifier)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .projectIdentifier(ProjectId.unwrap(projectIdentifier): java.lang.String)
      .optionallyWith(provider.map(value => value: java.lang.String))(
        _.provider
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListEnvironmentsRequest.ReadOnly =
    zio.aws.datazone.model.ListEnvironmentsRequest.wrap(buildAwsValue())
}
object ListEnvironmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListEnvironmentsRequest =
      zio.aws.datazone.model.ListEnvironmentsRequest(
        awsAccountId.map(value => value),
        awsAccountRegion.map(value => value),
        domainIdentifier,
        environmentBlueprintIdentifier.map(value => value),
        environmentProfileIdentifier.map(value => value),
        maxResults.map(value => value),
        name.map(value => value),
        nextToken.map(value => value),
        projectIdentifier,
        provider.map(value => value),
        status.map(value => value)
      )
    def awsAccountId: Optional[AwsAccountId]
    def awsAccountRegion: Optional[AwsRegion]
    def domainIdentifier: DomainId
    def environmentBlueprintIdentifier: Optional[EnvironmentBlueprintId]
    def environmentProfileIdentifier: Optional[EnvironmentProfileId]
    def maxResults: Optional[MaxResults]
    def name: Optional[String]
    def nextToken: Optional[PaginationToken]
    def projectIdentifier: ProjectId
    def provider: Optional[String]
    def status: Optional[zio.aws.datazone.model.EnvironmentStatus]
    def getAwsAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsAccountRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsAccountRegion", awsAccountRegion)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentBlueprintIdentifier
        : ZIO[Any, AwsError, EnvironmentBlueprintId] =
      AwsError.unwrapOptionField(
        "environmentBlueprintIdentifier",
        environmentBlueprintIdentifier
      )
    def getEnvironmentProfileIdentifier
        : ZIO[Any, AwsError, EnvironmentProfileId] = AwsError.unwrapOptionField(
      "environmentProfileIdentifier",
      environmentProfileIdentifier
    )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProjectIdentifier: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(projectIdentifier)
    def getProvider: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("provider", provider)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.EnvironmentStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest
  ) extends zio.aws.datazone.model.ListEnvironmentsRequest.ReadOnly {
    override val awsAccountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.datazone.model.primitives.AwsAccountId(value))
    override val awsAccountRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountRegion())
      .map(value => zio.aws.datazone.model.primitives.AwsRegion(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentBlueprintIdentifier
        : Optional[EnvironmentBlueprintId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentBlueprintIdentifier())
      .map(value =>
        zio.aws.datazone.model.primitives.EnvironmentBlueprintId(value)
      )
    override val environmentProfileIdentifier: Optional[EnvironmentProfileId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentProfileIdentifier())
        .map(value =>
          zio.aws.datazone.model.primitives.EnvironmentProfileId(value)
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val projectIdentifier: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectIdentifier())
    override val provider: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.provider())
      .map(value => value: String)
    override val status: Optional[zio.aws.datazone.model.EnvironmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.EnvironmentStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest
  ): zio.aws.datazone.model.ListEnvironmentsRequest.ReadOnly = new Wrapper(impl)
}
