package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  EnvironmentProfileName,
  ProjectId,
  DomainId,
  PaginationToken,
  EnvironmentBlueprintId,
  MaxResults,
  AwsRegion,
  AwsAccountId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEnvironmentProfilesRequest(
    awsAccountId: Optional[AwsAccountId] = Optional.Absent,
    awsAccountRegion: Optional[AwsRegion] = Optional.Absent,
    domainIdentifier: DomainId,
    environmentBlueprintIdentifier: Optional[EnvironmentBlueprintId] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    name: Optional[EnvironmentProfileName] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    projectIdentifier: Optional[ProjectId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest = {
    import ListEnvironmentProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest
      .builder()
      .optionallyWith(
        awsAccountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        awsAccountRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsAccountRegion)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        environmentBlueprintIdentifier.map(value =>
          EnvironmentBlueprintId.unwrap(value): java.lang.String
        )
      )(_.environmentBlueprintIdentifier)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        name.map(value =>
          EnvironmentProfileName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        projectIdentifier.map(value =>
          ProjectId.unwrap(value): java.lang.String
        )
      )(_.projectIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ListEnvironmentProfilesRequest.ReadOnly =
    zio.aws.datazone.model.ListEnvironmentProfilesRequest.wrap(buildAwsValue())
}
object ListEnvironmentProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListEnvironmentProfilesRequest =
      zio.aws.datazone.model.ListEnvironmentProfilesRequest(
        awsAccountId.map(value => value),
        awsAccountRegion.map(value => value),
        domainIdentifier,
        environmentBlueprintIdentifier.map(value => value),
        maxResults.map(value => value),
        name.map(value => value),
        nextToken.map(value => value),
        projectIdentifier.map(value => value)
      )
    def awsAccountId: Optional[AwsAccountId]
    def awsAccountRegion: Optional[AwsRegion]
    def domainIdentifier: DomainId
    def environmentBlueprintIdentifier: Optional[EnvironmentBlueprintId]
    def maxResults: Optional[MaxResults]
    def name: Optional[EnvironmentProfileName]
    def nextToken: Optional[PaginationToken]
    def projectIdentifier: Optional[ProjectId]
    def getAwsAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsAccountRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsAccountRegion", awsAccountRegion)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentBlueprintIdentifier
        : ZIO[Any, AwsError, EnvironmentBlueprintId] =
      AwsError.unwrapOptionField(
        "environmentBlueprintIdentifier",
        environmentBlueprintIdentifier
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getName: ZIO[Any, AwsError, EnvironmentProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProjectIdentifier: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("projectIdentifier", projectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest
  ) extends zio.aws.datazone.model.ListEnvironmentProfilesRequest.ReadOnly {
    override val awsAccountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.datazone.model.primitives.AwsAccountId(value))
    override val awsAccountRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountRegion())
      .map(value => zio.aws.datazone.model.primitives.AwsRegion(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentBlueprintIdentifier
        : Optional[EnvironmentBlueprintId] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentBlueprintIdentifier())
      .map(value =>
        zio.aws.datazone.model.primitives.EnvironmentBlueprintId(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val name: Optional[EnvironmentProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.datazone.model.primitives.EnvironmentProfileName(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val projectIdentifier: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.projectIdentifier())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentProfilesRequest
  ): zio.aws.datazone.model.ListEnvironmentProfilesRequest.ReadOnly =
    new Wrapper(impl)
}
