package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{SubscriptionId, DomainId}
import scala.jdk.CollectionConverters._
final case class GetSubscriptionRequest(
    domainIdentifier: DomainId,
    identifier: SubscriptionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest = {
    import GetSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(SubscriptionId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetSubscriptionRequest.ReadOnly =
    zio.aws.datazone.model.GetSubscriptionRequest.wrap(buildAwsValue())
}
object GetSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetSubscriptionRequest =
      zio.aws.datazone.model
        .GetSubscriptionRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: SubscriptionId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, SubscriptionId] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest
  ) extends zio.aws.datazone.model.GetSubscriptionRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: SubscriptionId =
      zio.aws.datazone.model.primitives.SubscriptionId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetSubscriptionRequest
  ): zio.aws.datazone.model.GetSubscriptionRequest.ReadOnly = new Wrapper(impl)
}
