package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  UpdatedBy,
  CreatedAt,
  DomainId,
  Revision,
  Description,
  ListingName,
  CreatedBy,
  UpdatedAt,
  ListingId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetListingResponse(
    createdAt: Optional[CreatedAt] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    id: ListingId,
    item: Optional[zio.aws.datazone.model.ListingItem] = Optional.Absent,
    listingRevision: Revision,
    name: Optional[ListingName] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.ListingStatus] = Optional.Absent,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetListingResponse = {
    import GetListingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetListingResponse
      .builder()
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .id(ListingId.unwrap(id): java.lang.String)
      .optionallyWith(item.map(value => value.buildAwsValue()))(_.item)
      .listingRevision(Revision.unwrap(listingRevision): java.lang.String)
      .optionallyWith(
        name.map(value => ListingName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetListingResponse.ReadOnly =
    zio.aws.datazone.model.GetListingResponse.wrap(buildAwsValue())
}
object GetListingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetListingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetListingResponse =
      zio.aws.datazone.model.GetListingResponse(
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        domainId,
        id,
        item.map(value => value.asEditable),
        listingRevision,
        name.map(value => value),
        status.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def createdAt: Optional[CreatedAt]
    def createdBy: Optional[CreatedBy]
    def description: Optional[Description]
    def domainId: DomainId
    def id: ListingId
    def item: Optional[zio.aws.datazone.model.ListingItem.ReadOnly]
    def listingRevision: Revision
    def name: Optional[ListingName]
    def status: Optional[zio.aws.datazone.model.ListingStatus]
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getId: ZIO[Any, Nothing, ListingId] = ZIO.succeed(id)
    def getItem
        : ZIO[Any, AwsError, zio.aws.datazone.model.ListingItem.ReadOnly] =
      AwsError.unwrapOptionField("item", item)
    def getListingRevision: ZIO[Any, Nothing, Revision] =
      ZIO.succeed(listingRevision)
    def getName: ZIO[Any, AwsError, ListingName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.ListingStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetListingResponse
  ) extends zio.aws.datazone.model.GetListingResponse.ReadOnly {
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val id: ListingId =
      zio.aws.datazone.model.primitives.ListingId(impl.id())
    override val item: Optional[zio.aws.datazone.model.ListingItem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.item())
        .map(value => zio.aws.datazone.model.ListingItem.wrap(value))
    override val listingRevision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.listingRevision())
    override val name: Optional[ListingName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datazone.model.primitives.ListingName(value))
    override val status: Optional[zio.aws.datazone.model.ListingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.ListingStatus.wrap(value))
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.datazone.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.datazone.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetListingResponse
  ): zio.aws.datazone.model.GetListingResponse.ReadOnly = new Wrapper(impl)
}
