package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  Revision,
  FormTypeIdentifier,
  DomainId
}
import scala.jdk.CollectionConverters._
final case class GetFormTypeRequest(
    domainIdentifier: DomainId,
    formTypeIdentifier: FormTypeIdentifier,
    revision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetFormTypeRequest = {
    import GetFormTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetFormTypeRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .formTypeIdentifier(
        FormTypeIdentifier.unwrap(formTypeIdentifier): java.lang.String
      )
      .optionallyWith(
        revision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.revision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetFormTypeRequest.ReadOnly =
    zio.aws.datazone.model.GetFormTypeRequest.wrap(buildAwsValue())
}
object GetFormTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetFormTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetFormTypeRequest =
      zio.aws.datazone.model.GetFormTypeRequest(
        domainIdentifier,
        formTypeIdentifier,
        revision.map(value => value)
      )
    def domainIdentifier: DomainId
    def formTypeIdentifier: FormTypeIdentifier
    def revision: Optional[Revision]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getFormTypeIdentifier: ZIO[Any, Nothing, FormTypeIdentifier] =
      ZIO.succeed(formTypeIdentifier)
    def getRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetFormTypeRequest
  ) extends zio.aws.datazone.model.GetFormTypeRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val formTypeIdentifier: FormTypeIdentifier =
      zio.aws.datazone.model.primitives
        .FormTypeIdentifier(impl.formTypeIdentifier())
    override val revision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetFormTypeRequest
  ): zio.aws.datazone.model.GetFormTypeRequest.ReadOnly = new Wrapper(impl)
}
