package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  EnvironmentProfileId,
  GlossaryTermId,
  ProjectId,
  SyntheticTimestamp_date_time,
  EnvironmentName,
  DomainId,
  EnvironmentId,
  Description,
  EnvironmentBlueprintId,
  AwsRegion,
  AwsAccountId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetEnvironmentResponse(
    awsAccountId: Optional[AwsAccountId] = Optional.Absent,
    awsAccountRegion: Optional[AwsRegion] = Optional.Absent,
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBy: String,
    deploymentProperties: Optional[
      zio.aws.datazone.model.DeploymentProperties
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    environmentActions: Optional[
      Iterable[zio.aws.datazone.model.ConfigurableEnvironmentAction]
    ] = Optional.Absent,
    environmentBlueprintId: Optional[EnvironmentBlueprintId] = Optional.Absent,
    environmentProfileId: EnvironmentProfileId,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    id: Optional[EnvironmentId] = Optional.Absent,
    lastDeployment: Optional[zio.aws.datazone.model.Deployment] =
      Optional.Absent,
    name: EnvironmentName,
    projectId: ProjectId,
    provider: String,
    provisionedResources: Optional[Iterable[zio.aws.datazone.model.Resource]] =
      Optional.Absent,
    provisioningProperties: Optional[
      zio.aws.datazone.model.ProvisioningProperties
    ] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.EnvironmentStatus] =
      Optional.Absent,
    updatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    userParameters: Optional[Iterable[zio.aws.datazone.model.CustomParameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetEnvironmentResponse = {
    import GetEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetEnvironmentResponse
      .builder()
      .optionallyWith(
        awsAccountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        awsAccountRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsAccountRegion)
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .createdBy(createdBy: java.lang.String)
      .optionallyWith(deploymentProperties.map(value => value.buildAwsValue()))(
        _.deploymentProperties
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        environmentActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentActions)
      .optionallyWith(
        environmentBlueprintId.map(value =>
          EnvironmentBlueprintId.unwrap(value): java.lang.String
        )
      )(_.environmentBlueprintId)
      .environmentProfileId(
        EnvironmentProfileId.unwrap(environmentProfileId): java.lang.String
      )
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .optionallyWith(
        id.map(value => EnvironmentId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(lastDeployment.map(value => value.buildAwsValue()))(
        _.lastDeployment
      )
      .name(EnvironmentName.unwrap(name): java.lang.String)
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .provider(provider: java.lang.String)
      .optionallyWith(
        provisionedResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedResources)
      .optionallyWith(
        provisioningProperties.map(value => value.buildAwsValue())
      )(_.provisioningProperties)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        updatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.updatedAt)
      .optionallyWith(
        userParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userParameters)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetEnvironmentResponse.ReadOnly =
    zio.aws.datazone.model.GetEnvironmentResponse.wrap(buildAwsValue())
}
object GetEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetEnvironmentResponse =
      zio.aws.datazone.model.GetEnvironmentResponse(
        awsAccountId.map(value => value),
        awsAccountRegion.map(value => value),
        createdAt.map(value => value),
        createdBy,
        deploymentProperties.map(value => value.asEditable),
        description.map(value => value),
        domainId,
        environmentActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentBlueprintId.map(value => value),
        environmentProfileId,
        glossaryTerms.map(value => value),
        id.map(value => value),
        lastDeployment.map(value => value.asEditable),
        name,
        projectId,
        provider,
        provisionedResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisioningProperties.map(value => value.asEditable),
        status.map(value => value),
        updatedAt.map(value => value),
        userParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def awsAccountId: Optional[AwsAccountId]
    def awsAccountRegion: Optional[AwsRegion]
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def createdBy: String
    def deploymentProperties
        : Optional[zio.aws.datazone.model.DeploymentProperties.ReadOnly]
    def description: Optional[Description]
    def domainId: DomainId
    def environmentActions: Optional[
      List[zio.aws.datazone.model.ConfigurableEnvironmentAction.ReadOnly]
    ]
    def environmentBlueprintId: Optional[EnvironmentBlueprintId]
    def environmentProfileId: EnvironmentProfileId
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def id: Optional[EnvironmentId]
    def lastDeployment: Optional[zio.aws.datazone.model.Deployment.ReadOnly]
    def name: EnvironmentName
    def projectId: ProjectId
    def provider: String
    def provisionedResources
        : Optional[List[zio.aws.datazone.model.Resource.ReadOnly]]
    def provisioningProperties
        : Optional[zio.aws.datazone.model.ProvisioningProperties.ReadOnly]
    def status: Optional[zio.aws.datazone.model.EnvironmentStatus]
    def updatedAt: Optional[SyntheticTimestamp_date_time]
    def userParameters
        : Optional[List[zio.aws.datazone.model.CustomParameter.ReadOnly]]
    def getAwsAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsAccountRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsAccountRegion", awsAccountRegion)
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, Nothing, String] = ZIO.succeed(createdBy)
    def getDeploymentProperties: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DeploymentProperties.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentProperties", deploymentProperties)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getEnvironmentActions: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.ConfigurableEnvironmentAction.ReadOnly
    ]] = AwsError.unwrapOptionField("environmentActions", environmentActions)
    def getEnvironmentBlueprintId: ZIO[Any, AwsError, EnvironmentBlueprintId] =
      AwsError.unwrapOptionField(
        "environmentBlueprintId",
        environmentBlueprintId
      )
    def getEnvironmentProfileId: ZIO[Any, Nothing, EnvironmentProfileId] =
      ZIO.succeed(environmentProfileId)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getId: ZIO[Any, AwsError, EnvironmentId] =
      AwsError.unwrapOptionField("id", id)
    def getLastDeployment
        : ZIO[Any, AwsError, zio.aws.datazone.model.Deployment.ReadOnly] =
      AwsError.unwrapOptionField("lastDeployment", lastDeployment)
    def getName: ZIO[Any, Nothing, EnvironmentName] = ZIO.succeed(name)
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getProvider: ZIO[Any, Nothing, String] = ZIO.succeed(provider)
    def getProvisionedResources
        : ZIO[Any, AwsError, List[zio.aws.datazone.model.Resource.ReadOnly]] =
      AwsError.unwrapOptionField("provisionedResources", provisionedResources)
    def getProvisioningProperties: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.ProvisioningProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "provisioningProperties",
      provisioningProperties
    )
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.EnvironmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUserParameters: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.CustomParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("userParameters", userParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentResponse
  ) extends zio.aws.datazone.model.GetEnvironmentResponse.ReadOnly {
    override val awsAccountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.datazone.model.primitives.AwsAccountId(value))
    override val awsAccountRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountRegion())
      .map(value => zio.aws.datazone.model.primitives.AwsRegion(value))
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBy: String = impl.createdBy(): String
    override val deploymentProperties
        : Optional[zio.aws.datazone.model.DeploymentProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentProperties())
        .map(value => zio.aws.datazone.model.DeploymentProperties.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val environmentActions: Optional[
      List[zio.aws.datazone.model.ConfigurableEnvironmentAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datazone.model.ConfigurableEnvironmentAction.wrap(item)
        }.toList
      )
    override val environmentBlueprintId: Optional[EnvironmentBlueprintId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentBlueprintId())
        .map(value =>
          zio.aws.datazone.model.primitives.EnvironmentBlueprintId(value)
        )
    override val environmentProfileId: EnvironmentProfileId =
      zio.aws.datazone.model.primitives
        .EnvironmentProfileId(impl.environmentProfileId())
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val id: Optional[EnvironmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.datazone.model.primitives.EnvironmentId(value))
    override val lastDeployment
        : Optional[zio.aws.datazone.model.Deployment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDeployment())
        .map(value => zio.aws.datazone.model.Deployment.wrap(value))
    override val name: EnvironmentName =
      zio.aws.datazone.model.primitives.EnvironmentName(impl.name())
    override val projectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectId())
    override val provider: String = impl.provider(): String
    override val provisionedResources
        : Optional[List[zio.aws.datazone.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.Resource.wrap(item)
          }.toList
        )
    override val provisioningProperties
        : Optional[zio.aws.datazone.model.ProvisioningProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisioningProperties())
        .map(value => zio.aws.datazone.model.ProvisioningProperties.wrap(value))
    override val status: Optional[zio.aws.datazone.model.EnvironmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.EnvironmentStatus.wrap(value))
    override val updatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val userParameters
        : Optional[List[zio.aws.datazone.model.CustomParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.CustomParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentResponse
  ): zio.aws.datazone.model.GetEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
