package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  EnvironmentProfileId,
  EnvironmentProfileName,
  ProjectId,
  SyntheticTimestamp_date_time,
  DomainId,
  Description,
  EnvironmentBlueprintId,
  AwsRegion,
  AwsAccountId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetEnvironmentProfileResponse(
    awsAccountId: Optional[AwsAccountId] = Optional.Absent,
    awsAccountRegion: Optional[AwsRegion] = Optional.Absent,
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBy: String,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    environmentBlueprintId: EnvironmentBlueprintId,
    id: EnvironmentProfileId,
    name: EnvironmentProfileName,
    projectId: Optional[ProjectId] = Optional.Absent,
    updatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    userParameters: Optional[Iterable[zio.aws.datazone.model.CustomParameter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileResponse = {
    import GetEnvironmentProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileResponse
      .builder()
      .optionallyWith(
        awsAccountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        awsAccountRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsAccountRegion)
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .createdBy(createdBy: java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .environmentBlueprintId(
        EnvironmentBlueprintId.unwrap(environmentBlueprintId): java.lang.String
      )
      .id(EnvironmentProfileId.unwrap(id): java.lang.String)
      .name(EnvironmentProfileName.unwrap(name): java.lang.String)
      .optionallyWith(
        projectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.projectId)
      .optionallyWith(
        updatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.updatedAt)
      .optionallyWith(
        userParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.GetEnvironmentProfileResponse.ReadOnly =
    zio.aws.datazone.model.GetEnvironmentProfileResponse.wrap(buildAwsValue())
}
object GetEnvironmentProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetEnvironmentProfileResponse =
      zio.aws.datazone.model.GetEnvironmentProfileResponse(
        awsAccountId.map(value => value),
        awsAccountRegion.map(value => value),
        createdAt.map(value => value),
        createdBy,
        description.map(value => value),
        domainId,
        environmentBlueprintId,
        id,
        name,
        projectId.map(value => value),
        updatedAt.map(value => value),
        userParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def awsAccountId: Optional[AwsAccountId]
    def awsAccountRegion: Optional[AwsRegion]
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def createdBy: String
    def description: Optional[Description]
    def domainId: DomainId
    def environmentBlueprintId: EnvironmentBlueprintId
    def id: EnvironmentProfileId
    def name: EnvironmentProfileName
    def projectId: Optional[ProjectId]
    def updatedAt: Optional[SyntheticTimestamp_date_time]
    def userParameters
        : Optional[List[zio.aws.datazone.model.CustomParameter.ReadOnly]]
    def getAwsAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsAccountRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsAccountRegion", awsAccountRegion)
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, Nothing, String] = ZIO.succeed(createdBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getEnvironmentBlueprintId: ZIO[Any, Nothing, EnvironmentBlueprintId] =
      ZIO.succeed(environmentBlueprintId)
    def getId: ZIO[Any, Nothing, EnvironmentProfileId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, EnvironmentProfileName] = ZIO.succeed(name)
    def getProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("projectId", projectId)
    def getUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUserParameters: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.CustomParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("userParameters", userParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileResponse
  ) extends zio.aws.datazone.model.GetEnvironmentProfileResponse.ReadOnly {
    override val awsAccountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.datazone.model.primitives.AwsAccountId(value))
    override val awsAccountRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountRegion())
      .map(value => zio.aws.datazone.model.primitives.AwsRegion(value))
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBy: String = impl.createdBy(): String
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val environmentBlueprintId: EnvironmentBlueprintId =
      zio.aws.datazone.model.primitives
        .EnvironmentBlueprintId(impl.environmentBlueprintId())
    override val id: EnvironmentProfileId =
      zio.aws.datazone.model.primitives.EnvironmentProfileId(impl.id())
    override val name: EnvironmentProfileName =
      zio.aws.datazone.model.primitives.EnvironmentProfileName(impl.name())
    override val projectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.projectId())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
    override val updatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val userParameters
        : Optional[List[zio.aws.datazone.model.CustomParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.CustomParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetEnvironmentProfileResponse
  ): zio.aws.datazone.model.GetEnvironmentProfileResponse.ReadOnly =
    new Wrapper(impl)
}
