package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.DomainId
import scala.jdk.CollectionConverters._
final case class GetDomainRequest(identifier: DomainId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetDomainRequest = {
    import GetDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetDomainRequest
      .builder()
      .identifier(DomainId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetDomainRequest.ReadOnly =
    zio.aws.datazone.model.GetDomainRequest.wrap(buildAwsValue())
}
object GetDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetDomainRequest =
      zio.aws.datazone.model.GetDomainRequest(identifier)
    def identifier: DomainId
    def getIdentifier: ZIO[Any, Nothing, DomainId] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetDomainRequest
  ) extends zio.aws.datazone.model.GetDomainRequest.ReadOnly {
    override val identifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetDomainRequest
  ): zio.aws.datazone.model.GetDomainRequest.ReadOnly = new Wrapper(impl)
}
