package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.FilterExpressionExpressionString
import scala.jdk.CollectionConverters._
final case class FilterExpression(
    expression: FilterExpressionExpressionString,
    `type`: zio.aws.datazone.model.FilterExpressionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.FilterExpression = {
    import FilterExpression.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.FilterExpression
      .builder()
      .expression(
        FilterExpressionExpressionString.unwrap(expression): java.lang.String
      )
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.FilterExpression.ReadOnly =
    zio.aws.datazone.model.FilterExpression.wrap(buildAwsValue())
}
object FilterExpression {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.FilterExpression
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.FilterExpression =
      zio.aws.datazone.model.FilterExpression(expression, `type`)
    def expression: FilterExpressionExpressionString
    def `type`: zio.aws.datazone.model.FilterExpressionType
    def getExpression: ZIO[Any, Nothing, FilterExpressionExpressionString] =
      ZIO.succeed(expression)
    def getType
        : ZIO[Any, Nothing, zio.aws.datazone.model.FilterExpressionType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.FilterExpression
  ) extends zio.aws.datazone.model.FilterExpression.ReadOnly {
    override val expression: FilterExpressionExpressionString =
      zio.aws.datazone.model.primitives
        .FilterExpressionExpressionString(impl.expression())
    override val `type`: zio.aws.datazone.model.FilterExpressionType =
      zio.aws.datazone.model.FilterExpressionType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.FilterExpression
  ): zio.aws.datazone.model.FilterExpression.ReadOnly = new Wrapper(impl)
}
