package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FilterClause(
    and: Optional[Iterable[zio.aws.datazone.model.FilterClause]] =
      Optional.Absent,
    filter: Optional[zio.aws.datazone.model.Filter] = Optional.Absent,
    or: Optional[Iterable[zio.aws.datazone.model.FilterClause]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.FilterClause = {
    import FilterClause.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.FilterClause
      .builder()
      .optionallyWith(
        and.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.and)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        or.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.or)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.FilterClause.ReadOnly =
    zio.aws.datazone.model.FilterClause.wrap(buildAwsValue())
}
object FilterClause {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.FilterClause
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.FilterClause =
      zio.aws.datazone.model.FilterClause(
        and.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filter.map(value => value.asEditable),
        or.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def and: Optional[List[zio.aws.datazone.model.FilterClause.ReadOnly]]
    def filter: Optional[zio.aws.datazone.model.Filter.ReadOnly]
    def or: Optional[List[zio.aws.datazone.model.FilterClause.ReadOnly]]
    def getAnd: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.FilterClause.ReadOnly
    ]] = AwsError.unwrapOptionField("and", and)
    def getFilter: ZIO[Any, AwsError, zio.aws.datazone.model.Filter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getOr: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.FilterClause.ReadOnly
    ]] = AwsError.unwrapOptionField("or", or)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.FilterClause
  ) extends zio.aws.datazone.model.FilterClause.ReadOnly {
    override val and
        : Optional[List[zio.aws.datazone.model.FilterClause.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.and())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FilterClause.wrap(item)
          }.toList
        )
    override val filter: Optional[zio.aws.datazone.model.Filter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.datazone.model.Filter.wrap(value))
    override val or
        : Optional[List[zio.aws.datazone.model.FilterClause.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.or())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FilterClause.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.FilterClause
  ): zio.aws.datazone.model.FilterClause.ReadOnly = new Wrapper(impl)
}
