package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EnvironmentParameter(
    name: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.EnvironmentParameter = {
    import EnvironmentParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.EnvironmentParameter
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.EnvironmentParameter.ReadOnly =
    zio.aws.datazone.model.EnvironmentParameter.wrap(buildAwsValue())
}
object EnvironmentParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.EnvironmentParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.EnvironmentParameter =
      zio.aws.datazone.model.EnvironmentParameter(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[String]
    def value: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.EnvironmentParameter
  ) extends zio.aws.datazone.model.EnvironmentParameter.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.EnvironmentParameter
  ): zio.aws.datazone.model.EnvironmentParameter.ReadOnly = new Wrapper(impl)
}
