package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  RoleArn,
  SyntheticTimestamp_date_time,
  DomainId,
  RegionName,
  EnvironmentBlueprintId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class EnvironmentBlueprintConfigurationItem(
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    domainId: DomainId,
    enabledRegions: Optional[Iterable[RegionName]] = Optional.Absent,
    environmentBlueprintId: EnvironmentBlueprintId,
    manageAccessRoleArn: Optional[RoleArn] = Optional.Absent,
    provisioningRoleArn: Optional[RoleArn] = Optional.Absent,
    regionalParameters: Optional[Map[RegionName, Map[String, String]]] =
      Optional.Absent,
    updatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintConfigurationItem = {
    import EnvironmentBlueprintConfigurationItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintConfigurationItem
      .builder()
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        enabledRegions.map(value =>
          value.map { item =>
            RegionName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.enabledRegions)
      .environmentBlueprintId(
        EnvironmentBlueprintId.unwrap(environmentBlueprintId): java.lang.String
      )
      .optionallyWith(
        manageAccessRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.manageAccessRoleArn)
      .optionallyWith(
        provisioningRoleArn.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.provisioningRoleArn)
      .optionallyWith(
        regionalParameters.map(value =>
          value
            .map({ case (key, value) =>
              (RegionName.unwrap(key): java.lang.String) -> value
                .map({ case (key, value) =>
                  (key: java.lang.String) -> (value: java.lang.String)
                })
                .asJava
            })
            .asJava
        )
      )(_.regionalParameters)
      .optionallyWith(
        updatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.updatedAt)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly =
    zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem
      .wrap(buildAwsValue())
}
object EnvironmentBlueprintConfigurationItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintConfigurationItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem =
      zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem(
        createdAt.map(value => value),
        domainId,
        enabledRegions.map(value => value),
        environmentBlueprintId,
        manageAccessRoleArn.map(value => value),
        provisioningRoleArn.map(value => value),
        regionalParameters.map(value => value),
        updatedAt.map(value => value)
      )
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def domainId: DomainId
    def enabledRegions: Optional[List[RegionName]]
    def environmentBlueprintId: EnvironmentBlueprintId
    def manageAccessRoleArn: Optional[RoleArn]
    def provisioningRoleArn: Optional[RoleArn]
    def regionalParameters: Optional[Map[RegionName, Map[String, String]]]
    def updatedAt: Optional[SyntheticTimestamp_date_time]
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getEnabledRegions: ZIO[Any, AwsError, List[RegionName]] =
      AwsError.unwrapOptionField("enabledRegions", enabledRegions)
    def getEnvironmentBlueprintId: ZIO[Any, Nothing, EnvironmentBlueprintId] =
      ZIO.succeed(environmentBlueprintId)
    def getManageAccessRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("manageAccessRoleArn", manageAccessRoleArn)
    def getProvisioningRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("provisioningRoleArn", provisioningRoleArn)
    def getRegionalParameters
        : ZIO[Any, AwsError, Map[RegionName, Map[String, String]]] =
      AwsError.unwrapOptionField("regionalParameters", regionalParameters)
    def getUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintConfigurationItem
  ) extends zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly {
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val enabledRegions: Optional[List[RegionName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabledRegions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.RegionName(item)
          }.toList
        )
    override val environmentBlueprintId: EnvironmentBlueprintId =
      zio.aws.datazone.model.primitives
        .EnvironmentBlueprintId(impl.environmentBlueprintId())
    override val manageAccessRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.manageAccessRoleArn())
      .map(value => zio.aws.datazone.model.primitives.RoleArn(value))
    override val provisioningRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningRoleArn())
      .map(value => zio.aws.datazone.model.primitives.RoleArn(value))
    override val regionalParameters
        : Optional[Map[RegionName, Map[String, String]]] = zio.aws.core.internal
      .optionalFromNullable(impl.regionalParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.datazone.model.primitives.RegionName(key) -> value.asScala
              .map({ case (key, value) =>
                (key: String) -> (value: String)
              })
              .toMap
          })
          .toMap
      )
    override val updatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintConfigurationItem
  ): zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly =
    new Wrapper(impl)
}
