package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.DomainId
import scala.jdk.CollectionConverters._
final case class DeleteDomainRequest(
    clientToken: Optional[String] = Optional.Absent,
    identifier: DomainId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeleteDomainRequest = {
    import DeleteDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeleteDomainRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .identifier(DomainId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeleteDomainRequest.ReadOnly =
    zio.aws.datazone.model.DeleteDomainRequest.wrap(buildAwsValue())
}
object DeleteDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeleteDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeleteDomainRequest =
      zio.aws.datazone.model
        .DeleteDomainRequest(clientToken.map(value => value), identifier)
    def clientToken: Optional[String]
    def identifier: DomainId
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getIdentifier: ZIO[Any, Nothing, DomainId] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeleteDomainRequest
  ) extends zio.aws.datazone.model.DeleteDomainRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val identifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeleteDomainRequest
  ): zio.aws.datazone.model.DeleteDomainRequest.ReadOnly = new Wrapper(impl)
}
