package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait DataSourceStatus {
  def unwrap: software.amazon.awssdk.services.datazone.model.DataSourceStatus
}
object DataSourceStatus {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.DataSourceStatus
  ): zio.aws.datazone.model.DataSourceStatus = value match {
    case software.amazon.awssdk.services.datazone.model.DataSourceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceStatus.FAILED_CREATION =>
      val r = FAILED_CREATION
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceStatus.FAILED_UPDATE =>
      val r = FAILED_UPDATE
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.datazone.model.DataSourceStatus.FAILED_DELETION =>
      val r = FAILED_DELETION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.datazone.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceStatus.CREATING
  }
  case object FAILED_CREATION extends zio.aws.datazone.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceStatus.FAILED_CREATION
  }
  case object READY extends zio.aws.datazone.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceStatus.READY
  }
  case object UPDATING extends zio.aws.datazone.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceStatus.UPDATING
  }
  case object FAILED_UPDATE extends zio.aws.datazone.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceStatus.FAILED_UPDATE
  }
  case object RUNNING extends zio.aws.datazone.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceStatus.RUNNING
  }
  case object DELETING extends zio.aws.datazone.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceStatus.DELETING
  }
  case object FAILED_DELETION extends zio.aws.datazone.model.DataSourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.DataSourceStatus =
      software.amazon.awssdk.services.datazone.model.DataSourceStatus.FAILED_DELETION
  }
}
