package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  SubscriptionTargetId,
  EnvironmentId,
  DomainId
}
import scala.jdk.CollectionConverters._
final case class CreateSubscriptionGrantRequest(
    assetTargetNames: Optional[
      Iterable[zio.aws.datazone.model.AssetTargetNameMap]
    ] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent,
    domainIdentifier: DomainId,
    environmentIdentifier: EnvironmentId,
    grantedEntity: zio.aws.datazone.model.GrantedEntityInput,
    subscriptionTargetIdentifier: SubscriptionTargetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest = {
    import CreateSubscriptionGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest
      .builder()
      .optionallyWith(
        assetTargetNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetTargetNames)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .environmentIdentifier(
        EnvironmentId.unwrap(environmentIdentifier): java.lang.String
      )
      .grantedEntity(grantedEntity.buildAwsValue())
      .subscriptionTargetIdentifier(
        SubscriptionTargetId.unwrap(
          subscriptionTargetIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.CreateSubscriptionGrantRequest.ReadOnly =
    zio.aws.datazone.model.CreateSubscriptionGrantRequest.wrap(buildAwsValue())
}
object CreateSubscriptionGrantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateSubscriptionGrantRequest =
      zio.aws.datazone.model.CreateSubscriptionGrantRequest(
        assetTargetNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        domainIdentifier,
        environmentIdentifier,
        grantedEntity.asEditable,
        subscriptionTargetIdentifier
      )
    def assetTargetNames
        : Optional[List[zio.aws.datazone.model.AssetTargetNameMap.ReadOnly]]
    def clientToken: Optional[String]
    def domainIdentifier: DomainId
    def environmentIdentifier: EnvironmentId
    def grantedEntity: zio.aws.datazone.model.GrantedEntityInput.ReadOnly
    def subscriptionTargetIdentifier: SubscriptionTargetId
    def getAssetTargetNames: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.AssetTargetNameMap.ReadOnly
    ]] = AwsError.unwrapOptionField("assetTargetNames", assetTargetNames)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentIdentifier: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentIdentifier)
    def getGrantedEntity: ZIO[
      Any,
      Nothing,
      zio.aws.datazone.model.GrantedEntityInput.ReadOnly
    ] = ZIO.succeed(grantedEntity)
    def getSubscriptionTargetIdentifier
        : ZIO[Any, Nothing, SubscriptionTargetId] =
      ZIO.succeed(subscriptionTargetIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest
  ) extends zio.aws.datazone.model.CreateSubscriptionGrantRequest.ReadOnly {
    override val assetTargetNames
        : Optional[List[zio.aws.datazone.model.AssetTargetNameMap.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetTargetNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.AssetTargetNameMap.wrap(item)
          }.toList
        )
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentIdentifier: EnvironmentId =
      zio.aws.datazone.model.primitives
        .EnvironmentId(impl.environmentIdentifier())
    override val grantedEntity
        : zio.aws.datazone.model.GrantedEntityInput.ReadOnly =
      zio.aws.datazone.model.GrantedEntityInput.wrap(impl.grantedEntity())
    override val subscriptionTargetIdentifier: SubscriptionTargetId =
      zio.aws.datazone.model.primitives
        .SubscriptionTargetId(impl.subscriptionTargetIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateSubscriptionGrantRequest
  ): zio.aws.datazone.model.CreateSubscriptionGrantRequest.ReadOnly =
    new Wrapper(impl)
}
