package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  Revision,
  EntityId,
  DomainId,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class CreateListingChangeSetRequest(
    action: zio.aws.datazone.model.ChangeAction,
    clientToken: Optional[ClientToken] = Optional.Absent,
    domainIdentifier: DomainId,
    entityIdentifier: EntityId,
    entityRevision: Optional[Revision] = Optional.Absent,
    entityType: zio.aws.datazone.model.EntityType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest = {
    import CreateListingChangeSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest
      .builder()
      .action(action.unwrap)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .entityIdentifier(EntityId.unwrap(entityIdentifier): java.lang.String)
      .optionallyWith(
        entityRevision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.entityRevision)
      .entityType(entityType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.CreateListingChangeSetRequest.ReadOnly =
    zio.aws.datazone.model.CreateListingChangeSetRequest.wrap(buildAwsValue())
}
object CreateListingChangeSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateListingChangeSetRequest =
      zio.aws.datazone.model.CreateListingChangeSetRequest(
        action,
        clientToken.map(value => value),
        domainIdentifier,
        entityIdentifier,
        entityRevision.map(value => value),
        entityType
      )
    def action: zio.aws.datazone.model.ChangeAction
    def clientToken: Optional[ClientToken]
    def domainIdentifier: DomainId
    def entityIdentifier: EntityId
    def entityRevision: Optional[Revision]
    def entityType: zio.aws.datazone.model.EntityType
    def getAction: ZIO[Any, Nothing, zio.aws.datazone.model.ChangeAction] =
      ZIO.succeed(action)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEntityIdentifier: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(entityIdentifier)
    def getEntityRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("entityRevision", entityRevision)
    def getEntityType: ZIO[Any, Nothing, zio.aws.datazone.model.EntityType] =
      ZIO.succeed(entityType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest
  ) extends zio.aws.datazone.model.CreateListingChangeSetRequest.ReadOnly {
    override val action: zio.aws.datazone.model.ChangeAction =
      zio.aws.datazone.model.ChangeAction.wrap(impl.action())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.datazone.model.primitives.ClientToken(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val entityIdentifier: EntityId =
      zio.aws.datazone.model.primitives.EntityId(impl.entityIdentifier())
    override val entityRevision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.entityRevision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
    override val entityType: zio.aws.datazone.model.EntityType =
      zio.aws.datazone.model.EntityType.wrap(impl.entityType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateListingChangeSetRequest
  ): zio.aws.datazone.model.CreateListingChangeSetRequest.ReadOnly =
    new Wrapper(impl)
}
