package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  ProjectId,
  DomainId,
  GlossaryDescription,
  GlossaryName,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class CreateGlossaryRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[GlossaryDescription] = Optional.Absent,
    domainIdentifier: DomainId,
    name: GlossaryName,
    owningProjectIdentifier: ProjectId,
    status: Optional[zio.aws.datazone.model.GlossaryStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest = {
    import CreateGlossaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          GlossaryDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .name(GlossaryName.unwrap(name): java.lang.String)
      .owningProjectIdentifier(
        ProjectId.unwrap(owningProjectIdentifier): java.lang.String
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateGlossaryRequest.ReadOnly =
    zio.aws.datazone.model.CreateGlossaryRequest.wrap(buildAwsValue())
}
object CreateGlossaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateGlossaryRequest =
      zio.aws.datazone.model.CreateGlossaryRequest(
        clientToken.map(value => value),
        description.map(value => value),
        domainIdentifier,
        name,
        owningProjectIdentifier,
        status.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[GlossaryDescription]
    def domainIdentifier: DomainId
    def name: GlossaryName
    def owningProjectIdentifier: ProjectId
    def status: Optional[zio.aws.datazone.model.GlossaryStatus]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, GlossaryDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getName: ZIO[Any, Nothing, GlossaryName] = ZIO.succeed(name)
    def getOwningProjectIdentifier: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(owningProjectIdentifier)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.GlossaryStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest
  ) extends zio.aws.datazone.model.CreateGlossaryRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.datazone.model.primitives.ClientToken(value))
    override val description: Optional[GlossaryDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.datazone.model.primitives.GlossaryDescription(value)
        )
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val name: GlossaryName =
      zio.aws.datazone.model.primitives.GlossaryName(impl.name())
    override val owningProjectIdentifier: ProjectId =
      zio.aws.datazone.model.primitives
        .ProjectId(impl.owningProjectIdentifier())
    override val status: Optional[zio.aws.datazone.model.GlossaryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.GlossaryStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateGlossaryRequest
  ): zio.aws.datazone.model.CreateGlossaryRequest.ReadOnly = new Wrapper(impl)
}
