package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  ProjectId,
  GlossaryTermId,
  EnvironmentProfileId,
  DomainId
}
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentRequest(
    description: Optional[String] = Optional.Absent,
    domainIdentifier: DomainId,
    environmentProfileIdentifier: EnvironmentProfileId,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    name: String,
    projectIdentifier: ProjectId,
    userParameters: Optional[
      Iterable[zio.aws.datazone.model.EnvironmentParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest = {
    import CreateEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .environmentProfileIdentifier(
        EnvironmentProfileId.unwrap(
          environmentProfileIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .name(name: java.lang.String)
      .projectIdentifier(ProjectId.unwrap(projectIdentifier): java.lang.String)
      .optionallyWith(
        userParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userParameters)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateEnvironmentRequest.ReadOnly =
    zio.aws.datazone.model.CreateEnvironmentRequest.wrap(buildAwsValue())
}
object CreateEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateEnvironmentRequest =
      zio.aws.datazone.model.CreateEnvironmentRequest(
        description.map(value => value),
        domainIdentifier,
        environmentProfileIdentifier,
        glossaryTerms.map(value => value),
        name,
        projectIdentifier,
        userParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Optional[String]
    def domainIdentifier: DomainId
    def environmentProfileIdentifier: EnvironmentProfileId
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def name: String
    def projectIdentifier: ProjectId
    def userParameters
        : Optional[List[zio.aws.datazone.model.EnvironmentParameter.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentProfileIdentifier
        : ZIO[Any, Nothing, EnvironmentProfileId] =
      ZIO.succeed(environmentProfileIdentifier)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getProjectIdentifier: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(projectIdentifier)
    def getUserParameters: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.EnvironmentParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("userParameters", userParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest
  ) extends zio.aws.datazone.model.CreateEnvironmentRequest.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentProfileIdentifier: EnvironmentProfileId =
      zio.aws.datazone.model.primitives
        .EnvironmentProfileId(impl.environmentProfileIdentifier())
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val name: String = impl.name(): String
    override val projectIdentifier: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectIdentifier())
    override val userParameters
        : Optional[List[zio.aws.datazone.model.EnvironmentParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.EnvironmentParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateEnvironmentRequest
  ): zio.aws.datazone.model.CreateEnvironmentRequest.ReadOnly = new Wrapper(
    impl
  )
}
