package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  EnvironmentProfileName,
  ProjectId,
  DomainId,
  Description,
  EnvironmentBlueprintId,
  AwsRegion,
  AwsAccountId
}
import scala.jdk.CollectionConverters._
final case class CreateEnvironmentProfileRequest(
    awsAccountId: Optional[AwsAccountId] = Optional.Absent,
    awsAccountRegion: Optional[AwsRegion] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainIdentifier: DomainId,
    environmentBlueprintIdentifier: EnvironmentBlueprintId,
    name: EnvironmentProfileName,
    projectIdentifier: ProjectId,
    userParameters: Optional[
      Iterable[zio.aws.datazone.model.EnvironmentParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest = {
    import CreateEnvironmentProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest
      .builder()
      .optionallyWith(
        awsAccountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        awsAccountRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsAccountRegion)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .environmentBlueprintIdentifier(
        EnvironmentBlueprintId.unwrap(
          environmentBlueprintIdentifier
        ): java.lang.String
      )
      .name(EnvironmentProfileName.unwrap(name): java.lang.String)
      .projectIdentifier(ProjectId.unwrap(projectIdentifier): java.lang.String)
      .optionallyWith(
        userParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.CreateEnvironmentProfileRequest.ReadOnly =
    zio.aws.datazone.model.CreateEnvironmentProfileRequest.wrap(buildAwsValue())
}
object CreateEnvironmentProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateEnvironmentProfileRequest =
      zio.aws.datazone.model.CreateEnvironmentProfileRequest(
        awsAccountId.map(value => value),
        awsAccountRegion.map(value => value),
        description.map(value => value),
        domainIdentifier,
        environmentBlueprintIdentifier,
        name,
        projectIdentifier,
        userParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def awsAccountId: Optional[AwsAccountId]
    def awsAccountRegion: Optional[AwsRegion]
    def description: Optional[Description]
    def domainIdentifier: DomainId
    def environmentBlueprintIdentifier: EnvironmentBlueprintId
    def name: EnvironmentProfileName
    def projectIdentifier: ProjectId
    def userParameters
        : Optional[List[zio.aws.datazone.model.EnvironmentParameter.ReadOnly]]
    def getAwsAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsAccountRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsAccountRegion", awsAccountRegion)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getEnvironmentBlueprintIdentifier
        : ZIO[Any, Nothing, EnvironmentBlueprintId] =
      ZIO.succeed(environmentBlueprintIdentifier)
    def getName: ZIO[Any, Nothing, EnvironmentProfileName] = ZIO.succeed(name)
    def getProjectIdentifier: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(projectIdentifier)
    def getUserParameters: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.EnvironmentParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("userParameters", userParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest
  ) extends zio.aws.datazone.model.CreateEnvironmentProfileRequest.ReadOnly {
    override val awsAccountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.datazone.model.primitives.AwsAccountId(value))
    override val awsAccountRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountRegion())
      .map(value => zio.aws.datazone.model.primitives.AwsRegion(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val environmentBlueprintIdentifier: EnvironmentBlueprintId =
      zio.aws.datazone.model.primitives
        .EnvironmentBlueprintId(impl.environmentBlueprintIdentifier())
    override val name: EnvironmentProfileName =
      zio.aws.datazone.model.primitives.EnvironmentProfileName(impl.name())
    override val projectIdentifier: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectIdentifier())
    override val userParameters
        : Optional[List[zio.aws.datazone.model.EnvironmentParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.EnvironmentParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateEnvironmentProfileRequest
  ): zio.aws.datazone.model.CreateEnvironmentProfileRequest.ReadOnly =
    new Wrapper(impl)
}
