package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{TagValue, TagKey, KmsKeyArn, RoleArn}
import scala.jdk.CollectionConverters._
final case class CreateDomainRequest(
    clientToken: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    domainExecutionRole: RoleArn,
    kmsKeyIdentifier: Optional[KmsKeyArn] = Optional.Absent,
    name: String,
    singleSignOn: Optional[zio.aws.datazone.model.SingleSignOn] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateDomainRequest = {
    import CreateDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateDomainRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .domainExecutionRole(
        RoleArn.unwrap(domainExecutionRole): java.lang.String
      )
      .optionallyWith(
        kmsKeyIdentifier.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyIdentifier)
      .name(name: java.lang.String)
      .optionallyWith(singleSignOn.map(value => value.buildAwsValue()))(
        _.singleSignOn
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateDomainRequest.ReadOnly =
    zio.aws.datazone.model.CreateDomainRequest.wrap(buildAwsValue())
}
object CreateDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateDomainRequest =
      zio.aws.datazone.model.CreateDomainRequest(
        clientToken.map(value => value),
        description.map(value => value),
        domainExecutionRole,
        kmsKeyIdentifier.map(value => value),
        name,
        singleSignOn.map(value => value.asEditable),
        tags.map(value => value)
      )
    def clientToken: Optional[String]
    def description: Optional[String]
    def domainExecutionRole: RoleArn
    def kmsKeyIdentifier: Optional[KmsKeyArn]
    def name: String
    def singleSignOn: Optional[zio.aws.datazone.model.SingleSignOn.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDomainExecutionRole: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(domainExecutionRole)
    def getKmsKeyIdentifier: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyIdentifier", kmsKeyIdentifier)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getSingleSignOn
        : ZIO[Any, AwsError, zio.aws.datazone.model.SingleSignOn.ReadOnly] =
      AwsError.unwrapOptionField("singleSignOn", singleSignOn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateDomainRequest
  ) extends zio.aws.datazone.model.CreateDomainRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val domainExecutionRole: RoleArn =
      zio.aws.datazone.model.primitives.RoleArn(impl.domainExecutionRole())
    override val kmsKeyIdentifier: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyIdentifier())
      .map(value => zio.aws.datazone.model.primitives.KmsKeyArn(value))
    override val name: String = impl.name(): String
    override val singleSignOn
        : Optional[zio.aws.datazone.model.SingleSignOn.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleSignOn())
        .map(value => zio.aws.datazone.model.SingleSignOn.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.datazone.model.primitives
              .TagKey(key) -> zio.aws.datazone.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateDomainRequest
  ): zio.aws.datazone.model.CreateDomainRequest.ReadOnly = new Wrapper(impl)
}
