package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  DataSourceId,
  ProjectId,
  DomainId,
  DateTime,
  EnvironmentId,
  Description,
  DataSourceType,
  Name
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateDataSourceResponse(
    assetFormsOutput: Optional[Iterable[zio.aws.datazone.model.FormOutput]] =
      Optional.Absent,
    configuration: Optional[
      zio.aws.datazone.model.DataSourceConfigurationOutput
    ] = Optional.Absent,
    createdAt: Optional[DateTime] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    enableSetting: Optional[zio.aws.datazone.model.EnableSetting] =
      Optional.Absent,
    environmentId: EnvironmentId,
    errorMessage: Optional[zio.aws.datazone.model.DataSourceErrorMessage] =
      Optional.Absent,
    id: DataSourceId,
    lastRunAt: Optional[DateTime] = Optional.Absent,
    lastRunErrorMessage: Optional[
      zio.aws.datazone.model.DataSourceErrorMessage
    ] = Optional.Absent,
    lastRunStatus: Optional[zio.aws.datazone.model.DataSourceRunStatus] =
      Optional.Absent,
    name: Name,
    projectId: ProjectId,
    publishOnImport: Optional[Boolean] = Optional.Absent,
    recommendation: Optional[
      zio.aws.datazone.model.RecommendationConfiguration
    ] = Optional.Absent,
    schedule: Optional[zio.aws.datazone.model.ScheduleConfiguration] =
      Optional.Absent,
    status: Optional[zio.aws.datazone.model.DataSourceStatus] = Optional.Absent,
    `type`: Optional[DataSourceType] = Optional.Absent,
    updatedAt: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateDataSourceResponse = {
    import CreateDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateDataSourceResponse
      .builder()
      .optionallyWith(
        assetFormsOutput.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetFormsOutput)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(enableSetting.map(value => value.unwrap))(_.enableSetting)
      .environmentId(EnvironmentId.unwrap(environmentId): java.lang.String)
      .optionallyWith(errorMessage.map(value => value.buildAwsValue()))(
        _.errorMessage
      )
      .id(DataSourceId.unwrap(id): java.lang.String)
      .optionallyWith(lastRunAt.map(value => DateTime.unwrap(value): Instant))(
        _.lastRunAt
      )
      .optionallyWith(lastRunErrorMessage.map(value => value.buildAwsValue()))(
        _.lastRunErrorMessage
      )
      .optionallyWith(lastRunStatus.map(value => value.unwrap))(_.lastRunStatus)
      .name(Name.unwrap(name): java.lang.String)
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .optionallyWith(publishOnImport.map(value => value: java.lang.Boolean))(
        _.publishOnImport
      )
      .optionallyWith(recommendation.map(value => value.buildAwsValue()))(
        _.recommendation
      )
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        `type`.map(value => DataSourceType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(updatedAt.map(value => DateTime.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateDataSourceResponse.ReadOnly =
    zio.aws.datazone.model.CreateDataSourceResponse.wrap(buildAwsValue())
}
object CreateDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateDataSourceResponse =
      zio.aws.datazone.model.CreateDataSourceResponse(
        assetFormsOutput.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value.asEditable),
        createdAt.map(value => value),
        description.map(value => value),
        domainId,
        enableSetting.map(value => value),
        environmentId,
        errorMessage.map(value => value.asEditable),
        id,
        lastRunAt.map(value => value),
        lastRunErrorMessage.map(value => value.asEditable),
        lastRunStatus.map(value => value),
        name,
        projectId,
        publishOnImport.map(value => value),
        recommendation.map(value => value.asEditable),
        schedule.map(value => value.asEditable),
        status.map(value => value),
        `type`.map(value => value),
        updatedAt.map(value => value)
      )
    def assetFormsOutput
        : Optional[List[zio.aws.datazone.model.FormOutput.ReadOnly]]
    def configuration: Optional[
      zio.aws.datazone.model.DataSourceConfigurationOutput.ReadOnly
    ]
    def createdAt: Optional[DateTime]
    def description: Optional[Description]
    def domainId: DomainId
    def enableSetting: Optional[zio.aws.datazone.model.EnableSetting]
    def environmentId: EnvironmentId
    def errorMessage
        : Optional[zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly]
    def id: DataSourceId
    def lastRunAt: Optional[DateTime]
    def lastRunErrorMessage
        : Optional[zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly]
    def lastRunStatus: Optional[zio.aws.datazone.model.DataSourceRunStatus]
    def name: Name
    def projectId: ProjectId
    def publishOnImport: Optional[Boolean]
    def recommendation
        : Optional[zio.aws.datazone.model.RecommendationConfiguration.ReadOnly]
    def schedule
        : Optional[zio.aws.datazone.model.ScheduleConfiguration.ReadOnly]
    def status: Optional[zio.aws.datazone.model.DataSourceStatus]
    def `type`: Optional[DataSourceType]
    def updatedAt: Optional[DateTime]
    def getAssetFormsOutput
        : ZIO[Any, AwsError, List[zio.aws.datazone.model.FormOutput.ReadOnly]] =
      AwsError.unwrapOptionField("assetFormsOutput", assetFormsOutput)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceConfigurationOutput.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getEnableSetting
        : ZIO[Any, AwsError, zio.aws.datazone.model.EnableSetting] =
      AwsError.unwrapOptionField("enableSetting", enableSetting)
    def getEnvironmentId: ZIO[Any, Nothing, EnvironmentId] =
      ZIO.succeed(environmentId)
    def getErrorMessage: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly
    ] = AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getId: ZIO[Any, Nothing, DataSourceId] = ZIO.succeed(id)
    def getLastRunAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastRunAt", lastRunAt)
    def getLastRunErrorMessage: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly
    ] = AwsError.unwrapOptionField("lastRunErrorMessage", lastRunErrorMessage)
    def getLastRunStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.DataSourceRunStatus] =
      AwsError.unwrapOptionField("lastRunStatus", lastRunStatus)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getPublishOnImport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publishOnImport", publishOnImport)
    def getRecommendation: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.RecommendationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("recommendation", recommendation)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.ScheduleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.DataSourceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, DataSourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUpdatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateDataSourceResponse
  ) extends zio.aws.datazone.model.CreateDataSourceResponse.ReadOnly {
    override val assetFormsOutput
        : Optional[List[zio.aws.datazone.model.FormOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assetFormsOutput())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FormOutput.wrap(item)
          }.toList
        )
    override val configuration: Optional[
      zio.aws.datazone.model.DataSourceConfigurationOutput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.datazone.model.DataSourceConfigurationOutput.wrap(value)
      )
    override val createdAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.DateTime(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val enableSetting: Optional[zio.aws.datazone.model.EnableSetting] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableSetting())
        .map(value => zio.aws.datazone.model.EnableSetting.wrap(value))
    override val environmentId: EnvironmentId =
      zio.aws.datazone.model.primitives.EnvironmentId(impl.environmentId())
    override val errorMessage
        : Optional[zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorMessage())
        .map(value => zio.aws.datazone.model.DataSourceErrorMessage.wrap(value))
    override val id: DataSourceId =
      zio.aws.datazone.model.primitives.DataSourceId(impl.id())
    override val lastRunAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastRunAt())
      .map(value => zio.aws.datazone.model.primitives.DateTime(value))
    override val lastRunErrorMessage
        : Optional[zio.aws.datazone.model.DataSourceErrorMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRunErrorMessage())
        .map(value => zio.aws.datazone.model.DataSourceErrorMessage.wrap(value))
    override val lastRunStatus
        : Optional[zio.aws.datazone.model.DataSourceRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRunStatus())
        .map(value => zio.aws.datazone.model.DataSourceRunStatus.wrap(value))
    override val name: Name =
      zio.aws.datazone.model.primitives.Name(impl.name())
    override val projectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.projectId())
    override val publishOnImport: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publishOnImport())
      .map(value => value: Boolean)
    override val recommendation: Optional[
      zio.aws.datazone.model.RecommendationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendation())
      .map(value =>
        zio.aws.datazone.model.RecommendationConfiguration.wrap(value)
      )
    override val schedule
        : Optional[zio.aws.datazone.model.ScheduleConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.datazone.model.ScheduleConfiguration.wrap(value))
    override val status: Optional[zio.aws.datazone.model.DataSourceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.DataSourceStatus.wrap(value))
    override val `type`: Optional[DataSourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.datazone.model.primitives.DataSourceType(value))
    override val updatedAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.datazone.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateDataSourceResponse
  ): zio.aws.datazone.model.CreateDataSourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
