package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConfigurableEnvironmentAction(
    auth: Optional[zio.aws.datazone.model.ConfigurableActionTypeAuthorization] =
      Optional.Absent,
    parameters: Iterable[zio.aws.datazone.model.ConfigurableActionParameter],
    `type`: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ConfigurableEnvironmentAction = {
    import ConfigurableEnvironmentAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ConfigurableEnvironmentAction
      .builder()
      .optionallyWith(auth.map(value => value.unwrap))(_.auth)
      .parameters(parameters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ConfigurableEnvironmentAction.ReadOnly =
    zio.aws.datazone.model.ConfigurableEnvironmentAction.wrap(buildAwsValue())
}
object ConfigurableEnvironmentAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ConfigurableEnvironmentAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ConfigurableEnvironmentAction =
      zio.aws.datazone.model.ConfigurableEnvironmentAction(
        auth.map(value => value),
        parameters.map { item =>
          item.asEditable
        },
        `type`
      )
    def auth
        : Optional[zio.aws.datazone.model.ConfigurableActionTypeAuthorization]
    def parameters
        : List[zio.aws.datazone.model.ConfigurableActionParameter.ReadOnly]
    def `type`: String
    def getAuth: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.ConfigurableActionTypeAuthorization
    ] = AwsError.unwrapOptionField("auth", auth)
    def getParameters: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.ConfigurableActionParameter.ReadOnly
    ]] = ZIO.succeed(parameters)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ConfigurableEnvironmentAction
  ) extends zio.aws.datazone.model.ConfigurableEnvironmentAction.ReadOnly {
    override val auth
        : Optional[zio.aws.datazone.model.ConfigurableActionTypeAuthorization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auth())
        .map(value =>
          zio.aws.datazone.model.ConfigurableActionTypeAuthorization.wrap(value)
        )
    override val parameters
        : List[zio.aws.datazone.model.ConfigurableActionParameter.ReadOnly] =
      impl
        .parameters()
        .asScala
        .map { item =>
          zio.aws.datazone.model.ConfigurableActionParameter.wrap(item)
        }
        .toList
    override val `type`: String = impl.`type`(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ConfigurableEnvironmentAction
  ): zio.aws.datazone.model.ConfigurableEnvironmentAction.ReadOnly =
    new Wrapper(impl)
}
