package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait AuthType {
  def unwrap: software.amazon.awssdk.services.datazone.model.AuthType
}
object AuthType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.AuthType
  ): zio.aws.datazone.model.AuthType = value match {
    case software.amazon.awssdk.services.datazone.model.AuthType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.AuthType.IAM_IDC =>
      val r = IAM_IDC
      r
    case software.amazon.awssdk.services.datazone.model.AuthType.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.datazone.model.AuthType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.AuthType =
      software.amazon.awssdk.services.datazone.model.AuthType.UNKNOWN_TO_SDK_VERSION
  }
  case object IAM_IDC extends zio.aws.datazone.model.AuthType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.AuthType =
      software.amazon.awssdk.services.datazone.model.AuthType.IAM_IDC
  }
  case object DISABLED extends zio.aws.datazone.model.AuthType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.AuthType =
      software.amazon.awssdk.services.datazone.model.AuthType.DISABLED
  }
}
