package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptRule(
    rule: Optional[zio.aws.datazone.model.AcceptRuleBehavior] = Optional.Absent,
    threshold: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.AcceptRule = {
    import AcceptRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.AcceptRule
      .builder()
      .optionallyWith(rule.map(value => value.unwrap))(_.rule)
      .optionallyWith(threshold.map(value => value: java.lang.Float))(
        _.threshold
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.AcceptRule.ReadOnly =
    zio.aws.datazone.model.AcceptRule.wrap(buildAwsValue())
}
object AcceptRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.AcceptRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.AcceptRule = zio.aws.datazone.model
      .AcceptRule(rule.map(value => value), threshold.map(value => value))
    def rule: Optional[zio.aws.datazone.model.AcceptRuleBehavior]
    def threshold: Optional[Float]
    def getRule: ZIO[Any, AwsError, zio.aws.datazone.model.AcceptRuleBehavior] =
      AwsError.unwrapOptionField("rule", rule)
    def getThreshold: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("threshold", threshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.AcceptRule
  ) extends zio.aws.datazone.model.AcceptRule.ReadOnly {
    override val rule: Optional[zio.aws.datazone.model.AcceptRuleBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rule())
        .map(value => zio.aws.datazone.model.AcceptRuleBehavior.wrap(value))
    override val threshold: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.threshold())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.AcceptRule
  ): zio.aws.datazone.model.AcceptRule.ReadOnly = new Wrapper(impl)
}
