package zio.aws.datazone
import zio.aws.datazone.model.ListSubscriptionsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient
import zio.aws.datazone.model.{
  DeleteAssetRequest,
  UpdateGroupProfileRequest,
  DeleteFormTypeRequest,
  DeleteListingRequest,
  CreateAssetRevisionRequest,
  GetAssetTypeRequest,
  CreateGroupProfileRequest,
  UpdateGlossaryTermRequest,
  CreateSubscriptionTargetRequest,
  GetEnvironmentRequest,
  GetUserProfileRequest,
  GetProjectRequest,
  GetSubscriptionRequestDetailsRequest,
  ListEnvironmentsRequest,
  UpdateDataSourceRequest,
  CreateProjectRequest,
  GetGroupProfileRequest,
  CreateSubscriptionRequestRequest,
  CreateGlossaryRequest,
  DeleteGlossaryRequest,
  UpdateDomainRequest,
  ListNotificationsRequest,
  UpdateGlossaryRequest,
  AcceptSubscriptionRequestRequest,
  UpdateEnvironmentRequest,
  ListEnvironmentBlueprintConfigurationsRequest,
  CreateSubscriptionGrantRequest,
  CreateListingChangeSetRequest,
  DeleteEnvironmentBlueprintConfigurationRequest,
  CreateFormTypeRequest,
  ListTagsForResourceRequest,
  ListSubscriptionRequestsRequest,
  PutEnvironmentBlueprintConfigurationRequest,
  CreateAssetRequest,
  CreateDataSourceRequest,
  AcceptPredictionsRequest,
  ListDataSourceRunActivitiesRequest,
  UpdateSubscriptionTargetRequest,
  RejectSubscriptionRequestRequest,
  UpdateProjectRequest,
  GetIamPortalLoginUrlRequest,
  GetSubscriptionGrantRequest,
  GetDataSourceRequest,
  SearchRequest,
  CreateGlossaryTermRequest,
  ListEnvironmentProfilesRequest,
  DeleteProjectRequest,
  DeleteDomainRequest,
  ListDataSourceRunsRequest,
  GetEnvironmentBlueprintRequest,
  ListSubscriptionsRequest,
  RevokeSubscriptionRequest,
  ListDataSourcesRequest,
  SearchUserProfilesRequest,
  DeleteProjectMembershipRequest,
  ListSubscriptionGrantsRequest,
  GetEnvironmentBlueprintConfigurationRequest,
  GetEnvironmentProfileRequest,
  DeleteDataSourceRequest,
  DeleteAssetTypeRequest,
  CreateDomainRequest,
  CreateProjectMembershipRequest,
  ListProjectsRequest,
  UntagResourceRequest,
  SearchTypesRequest,
  GetAssetRequest,
  ListProjectMembershipsRequest,
  GetDomainRequest,
  GetDataSourceRunRequest,
  GetSubscriptionRequest,
  UpdateSubscriptionRequestRequest,
  GetGlossaryRequest,
  GetFormTypeRequest,
  SearchGroupProfilesRequest,
  StartDataSourceRunRequest,
  SearchListingsRequest,
  CreateEnvironmentRequest,
  ListSubscriptionTargetsRequest,
  DeleteEnvironmentRequest,
  GetSubscriptionTargetRequest,
  DeleteSubscriptionTargetRequest,
  DeleteGlossaryTermRequest,
  GetGlossaryTermRequest,
  DeleteEnvironmentProfileRequest,
  GetListingRequest,
  CreateEnvironmentProfileRequest,
  RejectPredictionsRequest,
  DeleteSubscriptionGrantRequest,
  ListAssetRevisionsRequest,
  DeleteSubscriptionRequestRequest,
  UpdateEnvironmentProfileRequest,
  UpdateSubscriptionGrantStatusRequest,
  ListEnvironmentBlueprintsRequest,
  ListDomainsRequest,
  CreateUserProfileRequest,
  TagResourceRequest,
  UpdateUserProfileRequest,
  CancelSubscriptionRequest,
  CreateAssetTypeRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object DataZoneMock extends Mock[DataZone] {
  object UpdateSubscriptionRequest
      extends Effect[
        UpdateSubscriptionRequestRequest,
        AwsError,
        zio.aws.datazone.model.UpdateSubscriptionRequestResponse.ReadOnly
      ]
  object DeleteEnvironment
      extends Effect[DeleteEnvironmentRequest, AwsError, Unit]
  object CreateGlossaryTerm
      extends Effect[
        CreateGlossaryTermRequest,
        AwsError,
        zio.aws.datazone.model.CreateGlossaryTermResponse.ReadOnly
      ]
  object DeleteSubscriptionTarget
      extends Effect[DeleteSubscriptionTargetRequest, AwsError, Unit]
  object GetProject
      extends Effect[
        GetProjectRequest,
        AwsError,
        zio.aws.datazone.model.GetProjectResponse.ReadOnly
      ]
  object GetDataSource
      extends Effect[
        GetDataSourceRequest,
        AwsError,
        zio.aws.datazone.model.GetDataSourceResponse.ReadOnly
      ]
  object GetGroupProfile
      extends Effect[
        GetGroupProfileRequest,
        AwsError,
        zio.aws.datazone.model.GetGroupProfileResponse.ReadOnly
      ]
  object ListProjectMemberships
      extends Stream[
        ListProjectMembershipsRequest,
        AwsError,
        zio.aws.datazone.model.ProjectMember.ReadOnly
      ]
  object ListProjectMembershipsPaginated
      extends Effect[
        ListProjectMembershipsRequest,
        AwsError,
        zio.aws.datazone.model.ListProjectMembershipsResponse.ReadOnly
      ]
  object GetDataSourceRun
      extends Effect[
        GetDataSourceRunRequest,
        AwsError,
        zio.aws.datazone.model.GetDataSourceRunResponse.ReadOnly
      ]
  object CreateEnvironmentProfile
      extends Effect[
        CreateEnvironmentProfileRequest,
        AwsError,
        zio.aws.datazone.model.CreateEnvironmentProfileResponse.ReadOnly
      ]
  object ListEnvironmentBlueprints
      extends Stream[
        ListEnvironmentBlueprintsRequest,
        AwsError,
        zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly
      ]
  object ListEnvironmentBlueprintsPaginated
      extends Effect[
        ListEnvironmentBlueprintsRequest,
        AwsError,
        zio.aws.datazone.model.ListEnvironmentBlueprintsResponse.ReadOnly
      ]
  object ListSubscriptions
      extends Stream[
        ListSubscriptionsRequest,
        AwsError,
        zio.aws.datazone.model.SubscriptionSummary.ReadOnly
      ]
  object ListSubscriptionsPaginated
      extends Effect[ListSubscriptionsRequest, AwsError, ReadOnly]
  object CreateAssetType
      extends Effect[
        CreateAssetTypeRequest,
        AwsError,
        zio.aws.datazone.model.CreateAssetTypeResponse.ReadOnly
      ]
  object DeleteEnvironmentBlueprintConfiguration
      extends Effect[
        DeleteEnvironmentBlueprintConfigurationRequest,
        AwsError,
        zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationResponse.ReadOnly
      ]
  object ListNotifications
      extends Stream[
        ListNotificationsRequest,
        AwsError,
        zio.aws.datazone.model.NotificationOutput.ReadOnly
      ]
  object ListNotificationsPaginated
      extends Effect[
        ListNotificationsRequest,
        AwsError,
        zio.aws.datazone.model.ListNotificationsResponse.ReadOnly
      ]
  object UpdateProject
      extends Effect[
        UpdateProjectRequest,
        AwsError,
        zio.aws.datazone.model.UpdateProjectResponse.ReadOnly
      ]
  object CreateEnvironment
      extends Effect[
        CreateEnvironmentRequest,
        AwsError,
        zio.aws.datazone.model.CreateEnvironmentResponse.ReadOnly
      ]
  object ListSubscriptionTargets
      extends Stream[
        ListSubscriptionTargetsRequest,
        AwsError,
        zio.aws.datazone.model.SubscriptionTargetSummary.ReadOnly
      ]
  object ListSubscriptionTargetsPaginated
      extends Effect[
        ListSubscriptionTargetsRequest,
        AwsError,
        zio.aws.datazone.model.ListSubscriptionTargetsResponse.ReadOnly
      ]
  object SearchListings
      extends Stream[
        SearchListingsRequest,
        AwsError,
        zio.aws.datazone.model.SearchResultItem.ReadOnly
      ]
  object SearchListingsPaginated
      extends Effect[
        SearchListingsRequest,
        AwsError,
        zio.aws.datazone.model.SearchListingsResponse.ReadOnly
      ]
  object StartDataSourceRun
      extends Effect[
        StartDataSourceRunRequest,
        AwsError,
        zio.aws.datazone.model.StartDataSourceRunResponse.ReadOnly
      ]
  object GetSubscriptionRequestDetails
      extends Effect[
        GetSubscriptionRequestDetailsRequest,
        AwsError,
        zio.aws.datazone.model.GetSubscriptionRequestDetailsResponse.ReadOnly
      ]
  object GetEnvironment
      extends Effect[
        GetEnvironmentRequest,
        AwsError,
        zio.aws.datazone.model.GetEnvironmentResponse.ReadOnly
      ]
  object CreateFormType
      extends Effect[
        CreateFormTypeRequest,
        AwsError,
        zio.aws.datazone.model.CreateFormTypeResponse.ReadOnly
      ]
  object CreateSubscriptionTarget
      extends Effect[
        CreateSubscriptionTargetRequest,
        AwsError,
        zio.aws.datazone.model.CreateSubscriptionTargetResponse.ReadOnly
      ]
  object GetIamPortalLoginUrl
      extends Effect[
        GetIamPortalLoginUrlRequest,
        AwsError,
        zio.aws.datazone.model.GetIamPortalLoginUrlResponse.ReadOnly
      ]
  object CreateListingChangeSet
      extends Effect[
        CreateListingChangeSetRequest,
        AwsError,
        zio.aws.datazone.model.CreateListingChangeSetResponse.ReadOnly
      ]
  object RevokeSubscription
      extends Effect[
        RevokeSubscriptionRequest,
        AwsError,
        zio.aws.datazone.model.RevokeSubscriptionResponse.ReadOnly
      ]
  object RejectPredictions
      extends Effect[
        RejectPredictionsRequest,
        AwsError,
        zio.aws.datazone.model.RejectPredictionsResponse.ReadOnly
      ]
  object DeleteSubscriptionGrant
      extends Effect[
        DeleteSubscriptionGrantRequest,
        AwsError,
        zio.aws.datazone.model.DeleteSubscriptionGrantResponse.ReadOnly
      ]
  object GetDomain
      extends Effect[
        GetDomainRequest,
        AwsError,
        zio.aws.datazone.model.GetDomainResponse.ReadOnly
      ]
  object ListDataSourceRunActivities
      extends Stream[
        ListDataSourceRunActivitiesRequest,
        AwsError,
        zio.aws.datazone.model.DataSourceRunActivity.ReadOnly
      ]
  object ListDataSourceRunActivitiesPaginated
      extends Effect[
        ListDataSourceRunActivitiesRequest,
        AwsError,
        zio.aws.datazone.model.ListDataSourceRunActivitiesResponse.ReadOnly
      ]
  object CreateGroupProfile
      extends Effect[
        CreateGroupProfileRequest,
        AwsError,
        zio.aws.datazone.model.CreateGroupProfileResponse.ReadOnly
      ]
  object UpdateUserProfile
      extends Effect[
        UpdateUserProfileRequest,
        AwsError,
        zio.aws.datazone.model.UpdateUserProfileResponse.ReadOnly
      ]
  object ListSubscriptionRequests
      extends Stream[
        ListSubscriptionRequestsRequest,
        AwsError,
        zio.aws.datazone.model.SubscriptionRequestSummary.ReadOnly
      ]
  object ListSubscriptionRequestsPaginated
      extends Effect[
        ListSubscriptionRequestsRequest,
        AwsError,
        zio.aws.datazone.model.ListSubscriptionRequestsResponse.ReadOnly
      ]
  object GetFormType
      extends Effect[
        GetFormTypeRequest,
        AwsError,
        zio.aws.datazone.model.GetFormTypeResponse.ReadOnly
      ]
  object GetSubscription
      extends Effect[
        GetSubscriptionRequest,
        AwsError,
        zio.aws.datazone.model.GetSubscriptionResponse.ReadOnly
      ]
  object CreateDataSource
      extends Effect[
        CreateDataSourceRequest,
        AwsError,
        zio.aws.datazone.model.CreateDataSourceResponse.ReadOnly
      ]
  object ListDomains
      extends Stream[
        ListDomainsRequest,
        AwsError,
        zio.aws.datazone.model.DomainSummary.ReadOnly
      ]
  object ListDomainsPaginated
      extends Effect[
        ListDomainsRequest,
        AwsError,
        zio.aws.datazone.model.ListDomainsResponse.ReadOnly
      ]
  object DeleteGlossaryTerm
      extends Effect[
        DeleteGlossaryTermRequest,
        AwsError,
        zio.aws.datazone.model.DeleteGlossaryTermResponse.ReadOnly
      ]
  object UpdateSubscriptionGrantStatus
      extends Effect[
        UpdateSubscriptionGrantStatusRequest,
        AwsError,
        zio.aws.datazone.model.UpdateSubscriptionGrantStatusResponse.ReadOnly
      ]
  object PutEnvironmentBlueprintConfiguration
      extends Effect[
        PutEnvironmentBlueprintConfigurationRequest,
        AwsError,
        zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationResponse.ReadOnly
      ]
  object CreateSubscriptionGrant
      extends Effect[
        CreateSubscriptionGrantRequest,
        AwsError,
        zio.aws.datazone.model.CreateSubscriptionGrantResponse.ReadOnly
      ]
  object UpdateGroupProfile
      extends Effect[
        UpdateGroupProfileRequest,
        AwsError,
        zio.aws.datazone.model.UpdateGroupProfileResponse.ReadOnly
      ]
  object GetGlossaryTerm
      extends Effect[
        GetGlossaryTermRequest,
        AwsError,
        zio.aws.datazone.model.GetGlossaryTermResponse.ReadOnly
      ]
  object ListProjects
      extends Stream[
        ListProjectsRequest,
        AwsError,
        zio.aws.datazone.model.ProjectSummary.ReadOnly
      ]
  object ListProjectsPaginated
      extends Effect[
        ListProjectsRequest,
        AwsError,
        zio.aws.datazone.model.ListProjectsResponse.ReadOnly
      ]
  object GetSubscriptionTarget
      extends Effect[
        GetSubscriptionTargetRequest,
        AwsError,
        zio.aws.datazone.model.GetSubscriptionTargetResponse.ReadOnly
      ]
  object ListEnvironmentProfiles
      extends Stream[
        ListEnvironmentProfilesRequest,
        AwsError,
        zio.aws.datazone.model.EnvironmentProfileSummary.ReadOnly
      ]
  object ListEnvironmentProfilesPaginated
      extends Effect[
        ListEnvironmentProfilesRequest,
        AwsError,
        zio.aws.datazone.model.ListEnvironmentProfilesResponse.ReadOnly
      ]
  object ListDataSourceRuns
      extends Stream[
        ListDataSourceRunsRequest,
        AwsError,
        zio.aws.datazone.model.DataSourceRunSummary.ReadOnly
      ]
  object ListDataSourceRunsPaginated
      extends Effect[
        ListDataSourceRunsRequest,
        AwsError,
        zio.aws.datazone.model.ListDataSourceRunsResponse.ReadOnly
      ]
  object CreateAssetRevision
      extends Effect[
        CreateAssetRevisionRequest,
        AwsError,
        zio.aws.datazone.model.CreateAssetRevisionResponse.ReadOnly
      ]
  object UpdateGlossary
      extends Effect[
        UpdateGlossaryRequest,
        AwsError,
        zio.aws.datazone.model.UpdateGlossaryResponse.ReadOnly
      ]
  object GetSubscriptionGrant
      extends Effect[
        GetSubscriptionGrantRequest,
        AwsError,
        zio.aws.datazone.model.GetSubscriptionGrantResponse.ReadOnly
      ]
  object ListDataSources
      extends Stream[
        ListDataSourcesRequest,
        AwsError,
        zio.aws.datazone.model.DataSourceSummary.ReadOnly
      ]
  object ListDataSourcesPaginated
      extends Effect[
        ListDataSourcesRequest,
        AwsError,
        zio.aws.datazone.model.ListDataSourcesResponse.ReadOnly
      ]
  object GetEnvironmentProfile
      extends Effect[
        GetEnvironmentProfileRequest,
        AwsError,
        zio.aws.datazone.model.GetEnvironmentProfileResponse.ReadOnly
      ]
  object SearchUserProfiles
      extends Stream[
        SearchUserProfilesRequest,
        AwsError,
        zio.aws.datazone.model.UserProfileSummary.ReadOnly
      ]
  object SearchUserProfilesPaginated
      extends Effect[
        SearchUserProfilesRequest,
        AwsError,
        zio.aws.datazone.model.SearchUserProfilesResponse.ReadOnly
      ]
  object AcceptPredictions
      extends Effect[
        AcceptPredictionsRequest,
        AwsError,
        zio.aws.datazone.model.AcceptPredictionsResponse.ReadOnly
      ]
  object GetListing
      extends Effect[
        GetListingRequest,
        AwsError,
        zio.aws.datazone.model.GetListingResponse.ReadOnly
      ]
  object GetEnvironmentBlueprintConfiguration
      extends Effect[
        GetEnvironmentBlueprintConfigurationRequest,
        AwsError,
        zio.aws.datazone.model.GetEnvironmentBlueprintConfigurationResponse.ReadOnly
      ]
  object UpdateEnvironmentProfile
      extends Effect[
        UpdateEnvironmentProfileRequest,
        AwsError,
        zio.aws.datazone.model.UpdateEnvironmentProfileResponse.ReadOnly
      ]
  object CreateDomain
      extends Effect[
        CreateDomainRequest,
        AwsError,
        zio.aws.datazone.model.CreateDomainResponse.ReadOnly
      ]
  object ListAssetRevisions
      extends Stream[
        ListAssetRevisionsRequest,
        AwsError,
        zio.aws.datazone.model.AssetRevision.ReadOnly
      ]
  object ListAssetRevisionsPaginated
      extends Effect[
        ListAssetRevisionsRequest,
        AwsError,
        zio.aws.datazone.model.ListAssetRevisionsResponse.ReadOnly
      ]
  object DeleteFormType
      extends Effect[
        DeleteFormTypeRequest,
        AwsError,
        zio.aws.datazone.model.DeleteFormTypeResponse.ReadOnly
      ]
  object SearchTypes
      extends Stream[
        SearchTypesRequest,
        AwsError,
        zio.aws.datazone.model.SearchTypesResultItem.ReadOnly
      ]
  object SearchTypesPaginated
      extends Effect[
        SearchTypesRequest,
        AwsError,
        zio.aws.datazone.model.SearchTypesResponse.ReadOnly
      ]
  object GetGlossary
      extends Effect[
        GetGlossaryRequest,
        AwsError,
        zio.aws.datazone.model.GetGlossaryResponse.ReadOnly
      ]
  object CreateAsset
      extends Effect[
        CreateAssetRequest,
        AwsError,
        zio.aws.datazone.model.CreateAssetResponse.ReadOnly
      ]
  object ListEnvironments
      extends Stream[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.datazone.model.EnvironmentSummary.ReadOnly
      ]
  object ListEnvironmentsPaginated
      extends Effect[
        ListEnvironmentsRequest,
        AwsError,
        zio.aws.datazone.model.ListEnvironmentsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.datazone.model.UntagResourceResponse.ReadOnly
      ]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.datazone.model.CreateProjectResponse.ReadOnly
      ]
  object UpdateDomain
      extends Effect[
        UpdateDomainRequest,
        AwsError,
        zio.aws.datazone.model.UpdateDomainResponse.ReadOnly
      ]
  object UpdateDataSource
      extends Effect[
        UpdateDataSourceRequest,
        AwsError,
        zio.aws.datazone.model.UpdateDataSourceResponse.ReadOnly
      ]
  object ListEnvironmentBlueprintConfigurations
      extends Stream[
        ListEnvironmentBlueprintConfigurationsRequest,
        AwsError,
        zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly
      ]
  object ListEnvironmentBlueprintConfigurationsPaginated
      extends Effect[
        ListEnvironmentBlueprintConfigurationsRequest,
        AwsError,
        zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse.ReadOnly
      ]
  object DeleteDataSource
      extends Effect[
        DeleteDataSourceRequest,
        AwsError,
        zio.aws.datazone.model.DeleteDataSourceResponse.ReadOnly
      ]
  object GetUserProfile
      extends Effect[
        GetUserProfileRequest,
        AwsError,
        zio.aws.datazone.model.GetUserProfileResponse.ReadOnly
      ]
  object GetAsset
      extends Effect[
        GetAssetRequest,
        AwsError,
        zio.aws.datazone.model.GetAssetResponse.ReadOnly
      ]
  object GetEnvironmentBlueprint
      extends Effect[
        GetEnvironmentBlueprintRequest,
        AwsError,
        zio.aws.datazone.model.GetEnvironmentBlueprintResponse.ReadOnly
      ]
  object UpdateGlossaryTerm
      extends Effect[
        UpdateGlossaryTermRequest,
        AwsError,
        zio.aws.datazone.model.UpdateGlossaryTermResponse.ReadOnly
      ]
  object ListSubscriptionGrants
      extends Stream[
        ListSubscriptionGrantsRequest,
        AwsError,
        zio.aws.datazone.model.SubscriptionGrantSummary.ReadOnly
      ]
  object ListSubscriptionGrantsPaginated
      extends Effect[
        ListSubscriptionGrantsRequest,
        AwsError,
        zio.aws.datazone.model.ListSubscriptionGrantsResponse.ReadOnly
      ]
  object DeleteAsset
      extends Effect[
        DeleteAssetRequest,
        AwsError,
        zio.aws.datazone.model.DeleteAssetResponse.ReadOnly
      ]
  object GetAssetType
      extends Effect[
        GetAssetTypeRequest,
        AwsError,
        zio.aws.datazone.model.GetAssetTypeResponse.ReadOnly
      ]
  object DeleteProjectMembership
      extends Effect[
        DeleteProjectMembershipRequest,
        AwsError,
        zio.aws.datazone.model.DeleteProjectMembershipResponse.ReadOnly
      ]
  object DeleteSubscriptionRequest
      extends Effect[DeleteSubscriptionRequestRequest, AwsError, Unit]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.datazone.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.datazone.model.TagResourceResponse.ReadOnly
      ]
  object DeleteDomain
      extends Effect[
        DeleteDomainRequest,
        AwsError,
        zio.aws.datazone.model.DeleteDomainResponse.ReadOnly
      ]
  object AcceptSubscriptionRequest
      extends Effect[
        AcceptSubscriptionRequestRequest,
        AwsError,
        zio.aws.datazone.model.AcceptSubscriptionRequestResponse.ReadOnly
      ]
  object UpdateEnvironment
      extends Effect[
        UpdateEnvironmentRequest,
        AwsError,
        zio.aws.datazone.model.UpdateEnvironmentResponse.ReadOnly
      ]
  object RejectSubscriptionRequest
      extends Effect[
        RejectSubscriptionRequestRequest,
        AwsError,
        zio.aws.datazone.model.RejectSubscriptionRequestResponse.ReadOnly
      ]
  object UpdateSubscriptionTarget
      extends Effect[
        UpdateSubscriptionTargetRequest,
        AwsError,
        zio.aws.datazone.model.UpdateSubscriptionTargetResponse.ReadOnly
      ]
  object Search
      extends Stream[
        SearchRequest,
        AwsError,
        zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly
      ]
  object SearchPaginated
      extends Effect[
        SearchRequest,
        AwsError,
        zio.aws.datazone.model.SearchResponse.ReadOnly
      ]
  object CreateSubscriptionRequest
      extends Effect[
        CreateSubscriptionRequestRequest,
        AwsError,
        zio.aws.datazone.model.CreateSubscriptionRequestResponse.ReadOnly
      ]
  object CancelSubscription
      extends Effect[
        CancelSubscriptionRequest,
        AwsError,
        zio.aws.datazone.model.CancelSubscriptionResponse.ReadOnly
      ]
  object DeleteEnvironmentProfile
      extends Effect[DeleteEnvironmentProfileRequest, AwsError, Unit]
  object CreateGlossary
      extends Effect[
        CreateGlossaryRequest,
        AwsError,
        zio.aws.datazone.model.CreateGlossaryResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.datazone.model.DeleteProjectResponse.ReadOnly
      ]
  object DeleteAssetType
      extends Effect[
        DeleteAssetTypeRequest,
        AwsError,
        zio.aws.datazone.model.DeleteAssetTypeResponse.ReadOnly
      ]
  object DeleteListing
      extends Effect[
        DeleteListingRequest,
        AwsError,
        zio.aws.datazone.model.DeleteListingResponse.ReadOnly
      ]
  object DeleteGlossary
      extends Effect[
        DeleteGlossaryRequest,
        AwsError,
        zio.aws.datazone.model.DeleteGlossaryResponse.ReadOnly
      ]
  object CreateProjectMembership
      extends Effect[
        CreateProjectMembershipRequest,
        AwsError,
        zio.aws.datazone.model.CreateProjectMembershipResponse.ReadOnly
      ]
  object CreateUserProfile
      extends Effect[
        CreateUserProfileRequest,
        AwsError,
        zio.aws.datazone.model.CreateUserProfileResponse.ReadOnly
      ]
  object SearchGroupProfiles
      extends Stream[
        SearchGroupProfilesRequest,
        AwsError,
        zio.aws.datazone.model.GroupProfileSummary.ReadOnly
      ]
  object SearchGroupProfilesPaginated
      extends Effect[
        SearchGroupProfilesRequest,
        AwsError,
        zio.aws.datazone.model.SearchGroupProfilesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, DataZone] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, DataZone] { rts =>
        zio.ZIO.succeed {
          new DataZone {
            val api: DataZoneAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): DataZone = this
            def updateSubscriptionRequest(
                request: UpdateSubscriptionRequestRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.UpdateSubscriptionRequestResponse.ReadOnly
            ] = proxy(UpdateSubscriptionRequest, request)
            def deleteEnvironment(
                request: DeleteEnvironmentRequest
            ): IO[AwsError, Unit] = proxy(DeleteEnvironment, request)
            def createGlossaryTerm(request: CreateGlossaryTermRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateGlossaryTermResponse.ReadOnly
            ] = proxy(CreateGlossaryTerm, request)
            def deleteSubscriptionTarget(
                request: DeleteSubscriptionTargetRequest
            ): IO[AwsError, Unit] = proxy(DeleteSubscriptionTarget, request)
            def getProject(request: GetProjectRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetProjectResponse.ReadOnly
            ] = proxy(GetProject, request)
            def getDataSource(request: GetDataSourceRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetDataSourceResponse.ReadOnly
            ] = proxy(GetDataSource, request)
            def getGroupProfile(request: GetGroupProfileRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetGroupProfileResponse.ReadOnly
            ] = proxy(GetGroupProfile, request)
            def listProjectMemberships(
                request: ListProjectMembershipsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.ProjectMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProjectMemberships, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProjectMembershipsPaginated(
                request: ListProjectMembershipsRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListProjectMembershipsResponse.ReadOnly
            ] = proxy(ListProjectMembershipsPaginated, request)
            def getDataSourceRun(request: GetDataSourceRunRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetDataSourceRunResponse.ReadOnly
            ] = proxy(GetDataSourceRun, request)
            def createEnvironmentProfile(
                request: CreateEnvironmentProfileRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.CreateEnvironmentProfileResponse.ReadOnly
            ] = proxy(CreateEnvironmentProfile, request)
            def listEnvironmentBlueprints(
                request: ListEnvironmentBlueprintsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEnvironmentBlueprints, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEnvironmentBlueprintsPaginated(
                request: ListEnvironmentBlueprintsRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListEnvironmentBlueprintsResponse.ReadOnly
            ] = proxy(ListEnvironmentBlueprintsPaginated, request)
            def listSubscriptions(request: ListSubscriptionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.SubscriptionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSubscriptions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSubscriptionsPaginated(
                request: ListSubscriptionsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListSubscriptionsPaginated, request)
            def createAssetType(request: CreateAssetTypeRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateAssetTypeResponse.ReadOnly
            ] = proxy(CreateAssetType, request)
            def deleteEnvironmentBlueprintConfiguration(
                request: DeleteEnvironmentBlueprintConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.DeleteEnvironmentBlueprintConfigurationResponse.ReadOnly
            ] = proxy(DeleteEnvironmentBlueprintConfiguration, request)
            def listNotifications(request: ListNotificationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.NotificationOutput.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListNotifications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listNotificationsPaginated(
                request: ListNotificationsRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListNotificationsResponse.ReadOnly
            ] = proxy(ListNotificationsPaginated, request)
            def updateProject(request: UpdateProjectRequest): IO[
              AwsError,
              zio.aws.datazone.model.UpdateProjectResponse.ReadOnly
            ] = proxy(UpdateProject, request)
            def createEnvironment(request: CreateEnvironmentRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateEnvironmentResponse.ReadOnly
            ] = proxy(CreateEnvironment, request)
            def listSubscriptionTargets(
                request: ListSubscriptionTargetsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.SubscriptionTargetSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSubscriptionTargets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSubscriptionTargetsPaginated(
                request: ListSubscriptionTargetsRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListSubscriptionTargetsResponse.ReadOnly
            ] = proxy(ListSubscriptionTargetsPaginated, request)
            def searchListings(request: SearchListingsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.SearchResultItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchListings, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchListingsPaginated(request: SearchListingsRequest): IO[
              AwsError,
              zio.aws.datazone.model.SearchListingsResponse.ReadOnly
            ] = proxy(SearchListingsPaginated, request)
            def startDataSourceRun(request: StartDataSourceRunRequest): IO[
              AwsError,
              zio.aws.datazone.model.StartDataSourceRunResponse.ReadOnly
            ] = proxy(StartDataSourceRun, request)
            def getSubscriptionRequestDetails(
                request: GetSubscriptionRequestDetailsRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.GetSubscriptionRequestDetailsResponse.ReadOnly
            ] = proxy(GetSubscriptionRequestDetails, request)
            def getEnvironment(request: GetEnvironmentRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetEnvironmentResponse.ReadOnly
            ] = proxy(GetEnvironment, request)
            def createFormType(request: CreateFormTypeRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateFormTypeResponse.ReadOnly
            ] = proxy(CreateFormType, request)
            def createSubscriptionTarget(
                request: CreateSubscriptionTargetRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.CreateSubscriptionTargetResponse.ReadOnly
            ] = proxy(CreateSubscriptionTarget, request)
            def getIamPortalLoginUrl(request: GetIamPortalLoginUrlRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetIamPortalLoginUrlResponse.ReadOnly
            ] = proxy(GetIamPortalLoginUrl, request)
            def createListingChangeSet(
                request: CreateListingChangeSetRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.CreateListingChangeSetResponse.ReadOnly
            ] = proxy(CreateListingChangeSet, request)
            def revokeSubscription(request: RevokeSubscriptionRequest): IO[
              AwsError,
              zio.aws.datazone.model.RevokeSubscriptionResponse.ReadOnly
            ] = proxy(RevokeSubscription, request)
            def rejectPredictions(request: RejectPredictionsRequest): IO[
              AwsError,
              zio.aws.datazone.model.RejectPredictionsResponse.ReadOnly
            ] = proxy(RejectPredictions, request)
            def deleteSubscriptionGrant(
                request: DeleteSubscriptionGrantRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.DeleteSubscriptionGrantResponse.ReadOnly
            ] = proxy(DeleteSubscriptionGrant, request)
            def getDomain(
                request: GetDomainRequest
            ): IO[AwsError, zio.aws.datazone.model.GetDomainResponse.ReadOnly] =
              proxy(GetDomain, request)
            def listDataSourceRunActivities(
                request: ListDataSourceRunActivitiesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.DataSourceRunActivity.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataSourceRunActivities, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataSourceRunActivitiesPaginated(
                request: ListDataSourceRunActivitiesRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListDataSourceRunActivitiesResponse.ReadOnly
            ] = proxy(ListDataSourceRunActivitiesPaginated, request)
            def createGroupProfile(request: CreateGroupProfileRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateGroupProfileResponse.ReadOnly
            ] = proxy(CreateGroupProfile, request)
            def updateUserProfile(request: UpdateUserProfileRequest): IO[
              AwsError,
              zio.aws.datazone.model.UpdateUserProfileResponse.ReadOnly
            ] = proxy(UpdateUserProfile, request)
            def listSubscriptionRequests(
                request: ListSubscriptionRequestsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.SubscriptionRequestSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSubscriptionRequests, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSubscriptionRequestsPaginated(
                request: ListSubscriptionRequestsRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListSubscriptionRequestsResponse.ReadOnly
            ] = proxy(ListSubscriptionRequestsPaginated, request)
            def getFormType(request: GetFormTypeRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetFormTypeResponse.ReadOnly
            ] = proxy(GetFormType, request)
            def getSubscription(request: GetSubscriptionRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetSubscriptionResponse.ReadOnly
            ] = proxy(GetSubscription, request)
            def createDataSource(request: CreateDataSourceRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateDataSourceResponse.ReadOnly
            ] = proxy(CreateDataSource, request)
            def listDomains(request: ListDomainsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.DomainSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDomains, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDomainsPaginated(request: ListDomainsRequest): IO[
              AwsError,
              zio.aws.datazone.model.ListDomainsResponse.ReadOnly
            ] = proxy(ListDomainsPaginated, request)
            def deleteGlossaryTerm(request: DeleteGlossaryTermRequest): IO[
              AwsError,
              zio.aws.datazone.model.DeleteGlossaryTermResponse.ReadOnly
            ] = proxy(DeleteGlossaryTerm, request)
            def updateSubscriptionGrantStatus(
                request: UpdateSubscriptionGrantStatusRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.UpdateSubscriptionGrantStatusResponse.ReadOnly
            ] = proxy(UpdateSubscriptionGrantStatus, request)
            def putEnvironmentBlueprintConfiguration(
                request: PutEnvironmentBlueprintConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.PutEnvironmentBlueprintConfigurationResponse.ReadOnly
            ] = proxy(PutEnvironmentBlueprintConfiguration, request)
            def createSubscriptionGrant(
                request: CreateSubscriptionGrantRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.CreateSubscriptionGrantResponse.ReadOnly
            ] = proxy(CreateSubscriptionGrant, request)
            def updateGroupProfile(request: UpdateGroupProfileRequest): IO[
              AwsError,
              zio.aws.datazone.model.UpdateGroupProfileResponse.ReadOnly
            ] = proxy(UpdateGroupProfile, request)
            def getGlossaryTerm(request: GetGlossaryTermRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetGlossaryTermResponse.ReadOnly
            ] = proxy(GetGlossaryTerm, request)
            def listProjects(request: ListProjectsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.ProjectSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProjects, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProjectsPaginated(request: ListProjectsRequest): IO[
              AwsError,
              zio.aws.datazone.model.ListProjectsResponse.ReadOnly
            ] = proxy(ListProjectsPaginated, request)
            def getSubscriptionTarget(
                request: GetSubscriptionTargetRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.GetSubscriptionTargetResponse.ReadOnly
            ] = proxy(GetSubscriptionTarget, request)
            def listEnvironmentProfiles(
                request: ListEnvironmentProfilesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.EnvironmentProfileSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEnvironmentProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEnvironmentProfilesPaginated(
                request: ListEnvironmentProfilesRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListEnvironmentProfilesResponse.ReadOnly
            ] = proxy(ListEnvironmentProfilesPaginated, request)
            def listDataSourceRuns(request: ListDataSourceRunsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.DataSourceRunSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataSourceRuns, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataSourceRunsPaginated(
                request: ListDataSourceRunsRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListDataSourceRunsResponse.ReadOnly
            ] = proxy(ListDataSourceRunsPaginated, request)
            def createAssetRevision(request: CreateAssetRevisionRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateAssetRevisionResponse.ReadOnly
            ] = proxy(CreateAssetRevision, request)
            def updateGlossary(request: UpdateGlossaryRequest): IO[
              AwsError,
              zio.aws.datazone.model.UpdateGlossaryResponse.ReadOnly
            ] = proxy(UpdateGlossary, request)
            def getSubscriptionGrant(request: GetSubscriptionGrantRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetSubscriptionGrantResponse.ReadOnly
            ] = proxy(GetSubscriptionGrant, request)
            def listDataSources(request: ListDataSourcesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.DataSourceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataSources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataSourcesPaginated(request: ListDataSourcesRequest): IO[
              AwsError,
              zio.aws.datazone.model.ListDataSourcesResponse.ReadOnly
            ] = proxy(ListDataSourcesPaginated, request)
            def getEnvironmentProfile(
                request: GetEnvironmentProfileRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.GetEnvironmentProfileResponse.ReadOnly
            ] = proxy(GetEnvironmentProfile, request)
            def searchUserProfiles(request: SearchUserProfilesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.UserProfileSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchUserProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchUserProfilesPaginated(
                request: SearchUserProfilesRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.SearchUserProfilesResponse.ReadOnly
            ] = proxy(SearchUserProfilesPaginated, request)
            def acceptPredictions(request: AcceptPredictionsRequest): IO[
              AwsError,
              zio.aws.datazone.model.AcceptPredictionsResponse.ReadOnly
            ] = proxy(AcceptPredictions, request)
            def getListing(request: GetListingRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetListingResponse.ReadOnly
            ] = proxy(GetListing, request)
            def getEnvironmentBlueprintConfiguration(
                request: GetEnvironmentBlueprintConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.GetEnvironmentBlueprintConfigurationResponse.ReadOnly
            ] = proxy(GetEnvironmentBlueprintConfiguration, request)
            def updateEnvironmentProfile(
                request: UpdateEnvironmentProfileRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.UpdateEnvironmentProfileResponse.ReadOnly
            ] = proxy(UpdateEnvironmentProfile, request)
            def createDomain(request: CreateDomainRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateDomainResponse.ReadOnly
            ] = proxy(CreateDomain, request)
            def listAssetRevisions(request: ListAssetRevisionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.AssetRevision.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAssetRevisions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAssetRevisionsPaginated(
                request: ListAssetRevisionsRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListAssetRevisionsResponse.ReadOnly
            ] = proxy(ListAssetRevisionsPaginated, request)
            def deleteFormType(request: DeleteFormTypeRequest): IO[
              AwsError,
              zio.aws.datazone.model.DeleteFormTypeResponse.ReadOnly
            ] = proxy(DeleteFormType, request)
            def searchTypes(request: SearchTypesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.SearchTypesResultItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchTypes, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchTypesPaginated(request: SearchTypesRequest): IO[
              AwsError,
              zio.aws.datazone.model.SearchTypesResponse.ReadOnly
            ] = proxy(SearchTypesPaginated, request)
            def getGlossary(request: GetGlossaryRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetGlossaryResponse.ReadOnly
            ] = proxy(GetGlossary, request)
            def createAsset(request: CreateAssetRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateAssetResponse.ReadOnly
            ] = proxy(CreateAsset, request)
            def listEnvironments(request: ListEnvironmentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.EnvironmentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEnvironments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEnvironmentsPaginated(request: ListEnvironmentsRequest): IO[
              AwsError,
              zio.aws.datazone.model.ListEnvironmentsResponse.ReadOnly
            ] = proxy(ListEnvironmentsPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.datazone.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createProject(request: CreateProjectRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateProjectResponse.ReadOnly
            ] = proxy(CreateProject, request)
            def updateDomain(request: UpdateDomainRequest): IO[
              AwsError,
              zio.aws.datazone.model.UpdateDomainResponse.ReadOnly
            ] = proxy(UpdateDomain, request)
            def updateDataSource(request: UpdateDataSourceRequest): IO[
              AwsError,
              zio.aws.datazone.model.UpdateDataSourceResponse.ReadOnly
            ] = proxy(UpdateDataSource, request)
            def listEnvironmentBlueprintConfigurations(
                request: ListEnvironmentBlueprintConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.EnvironmentBlueprintConfigurationItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEnvironmentBlueprintConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEnvironmentBlueprintConfigurationsPaginated(
                request: ListEnvironmentBlueprintConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListEnvironmentBlueprintConfigurationsResponse.ReadOnly
            ] = proxy(ListEnvironmentBlueprintConfigurationsPaginated, request)
            def deleteDataSource(request: DeleteDataSourceRequest): IO[
              AwsError,
              zio.aws.datazone.model.DeleteDataSourceResponse.ReadOnly
            ] = proxy(DeleteDataSource, request)
            def getUserProfile(request: GetUserProfileRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetUserProfileResponse.ReadOnly
            ] = proxy(GetUserProfile, request)
            def getAsset(
                request: GetAssetRequest
            ): IO[AwsError, zio.aws.datazone.model.GetAssetResponse.ReadOnly] =
              proxy(GetAsset, request)
            def getEnvironmentBlueprint(
                request: GetEnvironmentBlueprintRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.GetEnvironmentBlueprintResponse.ReadOnly
            ] = proxy(GetEnvironmentBlueprint, request)
            def updateGlossaryTerm(request: UpdateGlossaryTermRequest): IO[
              AwsError,
              zio.aws.datazone.model.UpdateGlossaryTermResponse.ReadOnly
            ] = proxy(UpdateGlossaryTerm, request)
            def listSubscriptionGrants(
                request: ListSubscriptionGrantsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.SubscriptionGrantSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSubscriptionGrants, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSubscriptionGrantsPaginated(
                request: ListSubscriptionGrantsRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.ListSubscriptionGrantsResponse.ReadOnly
            ] = proxy(ListSubscriptionGrantsPaginated, request)
            def deleteAsset(request: DeleteAssetRequest): IO[
              AwsError,
              zio.aws.datazone.model.DeleteAssetResponse.ReadOnly
            ] = proxy(DeleteAsset, request)
            def getAssetType(request: GetAssetTypeRequest): IO[
              AwsError,
              zio.aws.datazone.model.GetAssetTypeResponse.ReadOnly
            ] = proxy(GetAssetType, request)
            def deleteProjectMembership(
                request: DeleteProjectMembershipRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.DeleteProjectMembershipResponse.ReadOnly
            ] = proxy(DeleteProjectMembership, request)
            def deleteSubscriptionRequest(
                request: DeleteSubscriptionRequestRequest
            ): IO[AwsError, Unit] = proxy(DeleteSubscriptionRequest, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.datazone.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.datazone.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def deleteDomain(request: DeleteDomainRequest): IO[
              AwsError,
              zio.aws.datazone.model.DeleteDomainResponse.ReadOnly
            ] = proxy(DeleteDomain, request)
            def acceptSubscriptionRequest(
                request: AcceptSubscriptionRequestRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.AcceptSubscriptionRequestResponse.ReadOnly
            ] = proxy(AcceptSubscriptionRequest, request)
            def updateEnvironment(request: UpdateEnvironmentRequest): IO[
              AwsError,
              zio.aws.datazone.model.UpdateEnvironmentResponse.ReadOnly
            ] = proxy(UpdateEnvironment, request)
            def rejectSubscriptionRequest(
                request: RejectSubscriptionRequestRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.RejectSubscriptionRequestResponse.ReadOnly
            ] = proxy(RejectSubscriptionRequest, request)
            def updateSubscriptionTarget(
                request: UpdateSubscriptionTargetRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.UpdateSubscriptionTargetResponse.ReadOnly
            ] = proxy(UpdateSubscriptionTarget, request)
            def search(request: SearchRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.SearchInventoryResultItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(Search, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchPaginated(
                request: SearchRequest
            ): IO[AwsError, zio.aws.datazone.model.SearchResponse.ReadOnly] =
              proxy(SearchPaginated, request)
            def createSubscriptionRequest(
                request: CreateSubscriptionRequestRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.CreateSubscriptionRequestResponse.ReadOnly
            ] = proxy(CreateSubscriptionRequest, request)
            def cancelSubscription(request: CancelSubscriptionRequest): IO[
              AwsError,
              zio.aws.datazone.model.CancelSubscriptionResponse.ReadOnly
            ] = proxy(CancelSubscription, request)
            def deleteEnvironmentProfile(
                request: DeleteEnvironmentProfileRequest
            ): IO[AwsError, Unit] = proxy(DeleteEnvironmentProfile, request)
            def createGlossary(request: CreateGlossaryRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateGlossaryResponse.ReadOnly
            ] = proxy(CreateGlossary, request)
            def deleteProject(request: DeleteProjectRequest): IO[
              AwsError,
              zio.aws.datazone.model.DeleteProjectResponse.ReadOnly
            ] = proxy(DeleteProject, request)
            def deleteAssetType(request: DeleteAssetTypeRequest): IO[
              AwsError,
              zio.aws.datazone.model.DeleteAssetTypeResponse.ReadOnly
            ] = proxy(DeleteAssetType, request)
            def deleteListing(request: DeleteListingRequest): IO[
              AwsError,
              zio.aws.datazone.model.DeleteListingResponse.ReadOnly
            ] = proxy(DeleteListing, request)
            def deleteGlossary(request: DeleteGlossaryRequest): IO[
              AwsError,
              zio.aws.datazone.model.DeleteGlossaryResponse.ReadOnly
            ] = proxy(DeleteGlossary, request)
            def createProjectMembership(
                request: CreateProjectMembershipRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.CreateProjectMembershipResponse.ReadOnly
            ] = proxy(CreateProjectMembership, request)
            def createUserProfile(request: CreateUserProfileRequest): IO[
              AwsError,
              zio.aws.datazone.model.CreateUserProfileResponse.ReadOnly
            ] = proxy(CreateUserProfile, request)
            def searchGroupProfiles(
                request: SearchGroupProfilesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datazone.model.GroupProfileSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SearchGroupProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def searchGroupProfilesPaginated(
                request: SearchGroupProfilesRequest
            ): IO[
              AwsError,
              zio.aws.datazone.model.SearchGroupProfilesResponse.ReadOnly
            ] = proxy(SearchGroupProfilesPaginated, request)
          }
        }
      }
    }
  }
}
