package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  GlossaryTermId,
  ProjectName,
  ProjectId,
  SyntheticTimestamp_date_time,
  DomainId,
  Description,
  CreatedBy
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateProjectResponse(
    createdAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    createdBy: CreatedBy,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    id: ProjectId,
    lastUpdatedAt: Optional[SyntheticTimestamp_date_time] = Optional.Absent,
    name: ProjectName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateProjectResponse = {
    import UpdateProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateProjectResponse
      .builder()
      .optionallyWith(
        createdAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.createdAt)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .id(ProjectId.unwrap(id): java.lang.String)
      .optionallyWith(
        lastUpdatedAt.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.lastUpdatedAt)
      .name(ProjectName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateProjectResponse.ReadOnly =
    zio.aws.datazone.model.UpdateProjectResponse.wrap(buildAwsValue())
}
object UpdateProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateProjectResponse =
      zio.aws.datazone.model.UpdateProjectResponse(
        createdAt.map(value => value),
        createdBy,
        description.map(value => value),
        domainId,
        glossaryTerms.map(value => value),
        id,
        lastUpdatedAt.map(value => value),
        name
      )
    def createdAt: Optional[SyntheticTimestamp_date_time]
    def createdBy: CreatedBy
    def description: Optional[Description]
    def domainId: DomainId
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def id: ProjectId
    def lastUpdatedAt: Optional[SyntheticTimestamp_date_time]
    def name: ProjectName
    def getCreatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(id)
    def getLastUpdatedAt: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateProjectResponse
  ) extends zio.aws.datazone.model.UpdateProjectResponse.ReadOnly {
    override val createdAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val createdBy: CreatedBy =
      zio.aws.datazone.model.primitives.CreatedBy(impl.createdBy())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val id: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.id())
    override val lastUpdatedAt: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedAt())
        .map(value =>
          zio.aws.datazone.model.primitives.SyntheticTimestamp_date_time(value)
        )
    override val name: ProjectName =
      zio.aws.datazone.model.primitives.ProjectName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateProjectResponse
  ): zio.aws.datazone.model.UpdateProjectResponse.ReadOnly = new Wrapper(impl)
}
