package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  LongDescription,
  GlossaryTermId,
  DomainId,
  ShortDescription,
  GlossaryTermName
}
import scala.jdk.CollectionConverters._
final case class UpdateGlossaryTermRequest(
    domainIdentifier: DomainId,
    glossaryIdentifier: Optional[GlossaryTermId] = Optional.Absent,
    identifier: GlossaryTermId,
    longDescription: Optional[LongDescription] = Optional.Absent,
    name: Optional[GlossaryTermName] = Optional.Absent,
    shortDescription: Optional[ShortDescription] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.GlossaryTermStatus] =
      Optional.Absent,
    termRelations: Optional[zio.aws.datazone.model.TermRelations] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermRequest = {
    import UpdateGlossaryTermRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        glossaryIdentifier.map(value =>
          GlossaryTermId.unwrap(value): java.lang.String
        )
      )(_.glossaryIdentifier)
      .identifier(GlossaryTermId.unwrap(identifier): java.lang.String)
      .optionallyWith(
        longDescription.map(value =>
          LongDescription.unwrap(value): java.lang.String
        )
      )(_.longDescription)
      .optionallyWith(
        name.map(value => GlossaryTermName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        shortDescription.map(value =>
          ShortDescription.unwrap(value): java.lang.String
        )
      )(_.shortDescription)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(termRelations.map(value => value.buildAwsValue()))(
        _.termRelations
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateGlossaryTermRequest.ReadOnly =
    zio.aws.datazone.model.UpdateGlossaryTermRequest.wrap(buildAwsValue())
}
object UpdateGlossaryTermRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateGlossaryTermRequest =
      zio.aws.datazone.model.UpdateGlossaryTermRequest(
        domainIdentifier,
        glossaryIdentifier.map(value => value),
        identifier,
        longDescription.map(value => value),
        name.map(value => value),
        shortDescription.map(value => value),
        status.map(value => value),
        termRelations.map(value => value.asEditable)
      )
    def domainIdentifier: DomainId
    def glossaryIdentifier: Optional[GlossaryTermId]
    def identifier: GlossaryTermId
    def longDescription: Optional[LongDescription]
    def name: Optional[GlossaryTermName]
    def shortDescription: Optional[ShortDescription]
    def status: Optional[zio.aws.datazone.model.GlossaryTermStatus]
    def termRelations: Optional[zio.aws.datazone.model.TermRelations.ReadOnly]
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getGlossaryIdentifier: ZIO[Any, AwsError, GlossaryTermId] =
      AwsError.unwrapOptionField("glossaryIdentifier", glossaryIdentifier)
    def getIdentifier: ZIO[Any, Nothing, GlossaryTermId] =
      ZIO.succeed(identifier)
    def getLongDescription: ZIO[Any, AwsError, LongDescription] =
      AwsError.unwrapOptionField("longDescription", longDescription)
    def getName: ZIO[Any, AwsError, GlossaryTermName] =
      AwsError.unwrapOptionField("name", name)
    def getShortDescription: ZIO[Any, AwsError, ShortDescription] =
      AwsError.unwrapOptionField("shortDescription", shortDescription)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.GlossaryTermStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTermRelations
        : ZIO[Any, AwsError, zio.aws.datazone.model.TermRelations.ReadOnly] =
      AwsError.unwrapOptionField("termRelations", termRelations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermRequest
  ) extends zio.aws.datazone.model.UpdateGlossaryTermRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val glossaryIdentifier: Optional[GlossaryTermId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryIdentifier())
        .map(value => zio.aws.datazone.model.primitives.GlossaryTermId(value))
    override val identifier: GlossaryTermId =
      zio.aws.datazone.model.primitives.GlossaryTermId(impl.identifier())
    override val longDescription: Optional[LongDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.longDescription())
        .map(value => zio.aws.datazone.model.primitives.LongDescription(value))
    override val name: Optional[GlossaryTermName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datazone.model.primitives.GlossaryTermName(value))
    override val shortDescription: Optional[ShortDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shortDescription())
        .map(value => zio.aws.datazone.model.primitives.ShortDescription(value))
    override val status: Optional[zio.aws.datazone.model.GlossaryTermStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.GlossaryTermStatus.wrap(value))
    override val termRelations
        : Optional[zio.aws.datazone.model.TermRelations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.termRelations())
        .map(value => zio.aws.datazone.model.TermRelations.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateGlossaryTermRequest
  ): zio.aws.datazone.model.UpdateGlossaryTermRequest.ReadOnly = new Wrapper(
    impl
  )
}
