package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait TaskStatus {
  def unwrap: software.amazon.awssdk.services.datazone.model.TaskStatus
}
object TaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.TaskStatus
  ): zio.aws.datazone.model.TaskStatus = value match {
    case software.amazon.awssdk.services.datazone.model.TaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.TaskStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.datazone.model.TaskStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.datazone.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.TaskStatus =
      software.amazon.awssdk.services.datazone.model.TaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.datazone.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.TaskStatus =
      software.amazon.awssdk.services.datazone.model.TaskStatus.ACTIVE
  }
  case object INACTIVE extends zio.aws.datazone.model.TaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.TaskStatus =
      software.amazon.awssdk.services.datazone.model.TaskStatus.INACTIVE
  }
}
