package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait GlossaryTermStatus {
  def unwrap: software.amazon.awssdk.services.datazone.model.GlossaryTermStatus
}
object GlossaryTermStatus {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.GlossaryTermStatus
  ): zio.aws.datazone.model.GlossaryTermStatus = value match {
    case software.amazon.awssdk.services.datazone.model.GlossaryTermStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.GlossaryTermStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.datazone.model.GlossaryTermStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.GlossaryTermStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.GlossaryTermStatus =
      software.amazon.awssdk.services.datazone.model.GlossaryTermStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.datazone.model.GlossaryTermStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.GlossaryTermStatus =
      software.amazon.awssdk.services.datazone.model.GlossaryTermStatus.ENABLED
  }
  case object DISABLED extends zio.aws.datazone.model.GlossaryTermStatus {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.GlossaryTermStatus =
      software.amazon.awssdk.services.datazone.model.GlossaryTermStatus.DISABLED
  }
}
