package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  DecisionComment,
  UpdatedBy,
  CreatedAt,
  DomainId,
  CreatedBy,
  RequestReason,
  SubscriptionRequestId,
  UpdatedAt
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateSubscriptionRequestResponse(
    createdAt: CreatedAt,
    createdBy: CreatedBy,
    decisionComment: Optional[DecisionComment] = Optional.Absent,
    domainId: DomainId,
    id: SubscriptionRequestId,
    requestReason: RequestReason,
    reviewerId: Optional[String] = Optional.Absent,
    status: zio.aws.datazone.model.SubscriptionRequestStatus,
    subscribedListings: Iterable[zio.aws.datazone.model.SubscribedListing],
    subscribedPrincipals: Iterable[zio.aws.datazone.model.SubscribedPrincipal],
    updatedAt: UpdatedAt,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestResponse = {
    import CreateSubscriptionRequestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestResponse
      .builder()
      .createdAt(CreatedAt.unwrap(createdAt): Instant)
      .createdBy(CreatedBy.unwrap(createdBy): java.lang.String)
      .optionallyWith(
        decisionComment.map(value =>
          DecisionComment.unwrap(value): java.lang.String
        )
      )(_.decisionComment)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .id(SubscriptionRequestId.unwrap(id): java.lang.String)
      .requestReason(RequestReason.unwrap(requestReason): java.lang.String)
      .optionallyWith(reviewerId.map(value => value: java.lang.String))(
        _.reviewerId
      )
      .status(status.unwrap)
      .subscribedListings(subscribedListings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .subscribedPrincipals(subscribedPrincipals.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .updatedAt(UpdatedAt.unwrap(updatedAt): Instant)
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.CreateSubscriptionRequestResponse.ReadOnly =
    zio.aws.datazone.model.CreateSubscriptionRequestResponse
      .wrap(buildAwsValue())
}
object CreateSubscriptionRequestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateSubscriptionRequestResponse =
      zio.aws.datazone.model.CreateSubscriptionRequestResponse(
        createdAt,
        createdBy,
        decisionComment.map(value => value),
        domainId,
        id,
        requestReason,
        reviewerId.map(value => value),
        status,
        subscribedListings.map { item =>
          item.asEditable
        },
        subscribedPrincipals.map { item =>
          item.asEditable
        },
        updatedAt,
        updatedBy.map(value => value)
      )
    def createdAt: CreatedAt
    def createdBy: CreatedBy
    def decisionComment: Optional[DecisionComment]
    def domainId: DomainId
    def id: SubscriptionRequestId
    def requestReason: RequestReason
    def reviewerId: Optional[String]
    def status: zio.aws.datazone.model.SubscriptionRequestStatus
    def subscribedListings
        : List[zio.aws.datazone.model.SubscribedListing.ReadOnly]
    def subscribedPrincipals
        : List[zio.aws.datazone.model.SubscribedPrincipal.ReadOnly]
    def updatedAt: UpdatedAt
    def updatedBy: Optional[UpdatedBy]
    def getCreatedAt: ZIO[Any, Nothing, CreatedAt] = ZIO.succeed(createdAt)
    def getCreatedBy: ZIO[Any, Nothing, CreatedBy] = ZIO.succeed(createdBy)
    def getDecisionComment: ZIO[Any, AwsError, DecisionComment] =
      AwsError.unwrapOptionField("decisionComment", decisionComment)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getId: ZIO[Any, Nothing, SubscriptionRequestId] = ZIO.succeed(id)
    def getRequestReason: ZIO[Any, Nothing, RequestReason] =
      ZIO.succeed(requestReason)
    def getReviewerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reviewerId", reviewerId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.datazone.model.SubscriptionRequestStatus] =
      ZIO.succeed(status)
    def getSubscribedListings: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.SubscribedListing.ReadOnly
    ]] = ZIO.succeed(subscribedListings)
    def getSubscribedPrincipals: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.SubscribedPrincipal.ReadOnly
    ]] = ZIO.succeed(subscribedPrincipals)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAt] = ZIO.succeed(updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestResponse
  ) extends zio.aws.datazone.model.CreateSubscriptionRequestResponse.ReadOnly {
    override val createdAt: CreatedAt =
      zio.aws.datazone.model.primitives.CreatedAt(impl.createdAt())
    override val createdBy: CreatedBy =
      zio.aws.datazone.model.primitives.CreatedBy(impl.createdBy())
    override val decisionComment: Optional[DecisionComment] =
      zio.aws.core.internal
        .optionalFromNullable(impl.decisionComment())
        .map(value => zio.aws.datazone.model.primitives.DecisionComment(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val id: SubscriptionRequestId =
      zio.aws.datazone.model.primitives.SubscriptionRequestId(impl.id())
    override val requestReason: RequestReason =
      zio.aws.datazone.model.primitives.RequestReason(impl.requestReason())
    override val reviewerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reviewerId())
      .map(value => value: String)
    override val status: zio.aws.datazone.model.SubscriptionRequestStatus =
      zio.aws.datazone.model.SubscriptionRequestStatus.wrap(impl.status())
    override val subscribedListings
        : List[zio.aws.datazone.model.SubscribedListing.ReadOnly] = impl
      .subscribedListings()
      .asScala
      .map { item =>
        zio.aws.datazone.model.SubscribedListing.wrap(item)
      }
      .toList
    override val subscribedPrincipals
        : List[zio.aws.datazone.model.SubscribedPrincipal.ReadOnly] = impl
      .subscribedPrincipals()
      .asScala
      .map { item =>
        zio.aws.datazone.model.SubscribedPrincipal.wrap(item)
      }
      .toList
    override val updatedAt: UpdatedAt =
      zio.aws.datazone.model.primitives.UpdatedAt(impl.updatedAt())
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.datazone.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestResponse
  ): zio.aws.datazone.model.CreateSubscriptionRequestResponse.ReadOnly =
    new Wrapper(impl)
}
