package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  EnvironmentProfileId,
  EnvironmentProfileName,
  DomainId,
  AwsRegion,
  AwsAccountId
}
import scala.jdk.CollectionConverters._
final case class UpdateEnvironmentProfileRequest(
    awsAccountId: Optional[AwsAccountId] = Optional.Absent,
    awsAccountRegion: Optional[AwsRegion] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    domainIdentifier: DomainId,
    identifier: EnvironmentProfileId,
    name: Optional[EnvironmentProfileName] = Optional.Absent,
    userParameters: Optional[
      Iterable[zio.aws.datazone.model.EnvironmentParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileRequest = {
    import UpdateEnvironmentProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileRequest
      .builder()
      .optionallyWith(
        awsAccountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        awsAccountRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsAccountRegion)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(EnvironmentProfileId.unwrap(identifier): java.lang.String)
      .optionallyWith(
        name.map(value =>
          EnvironmentProfileName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        userParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.UpdateEnvironmentProfileRequest.ReadOnly =
    zio.aws.datazone.model.UpdateEnvironmentProfileRequest.wrap(buildAwsValue())
}
object UpdateEnvironmentProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateEnvironmentProfileRequest =
      zio.aws.datazone.model.UpdateEnvironmentProfileRequest(
        awsAccountId.map(value => value),
        awsAccountRegion.map(value => value),
        description.map(value => value),
        domainIdentifier,
        identifier,
        name.map(value => value),
        userParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def awsAccountId: Optional[AwsAccountId]
    def awsAccountRegion: Optional[AwsRegion]
    def description: Optional[String]
    def domainIdentifier: DomainId
    def identifier: EnvironmentProfileId
    def name: Optional[EnvironmentProfileName]
    def userParameters
        : Optional[List[zio.aws.datazone.model.EnvironmentParameter.ReadOnly]]
    def getAwsAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAwsAccountRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsAccountRegion", awsAccountRegion)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, EnvironmentProfileId] =
      ZIO.succeed(identifier)
    def getName: ZIO[Any, AwsError, EnvironmentProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getUserParameters: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.EnvironmentParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("userParameters", userParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileRequest
  ) extends zio.aws.datazone.model.UpdateEnvironmentProfileRequest.ReadOnly {
    override val awsAccountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.datazone.model.primitives.AwsAccountId(value))
    override val awsAccountRegion: Optional[AwsRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountRegion())
      .map(value => zio.aws.datazone.model.primitives.AwsRegion(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: EnvironmentProfileId =
      zio.aws.datazone.model.primitives.EnvironmentProfileId(impl.identifier())
    override val name: Optional[EnvironmentProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.datazone.model.primitives.EnvironmentProfileName(value)
      )
    override val userParameters
        : Optional[List[zio.aws.datazone.model.EnvironmentParameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.EnvironmentParameter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateEnvironmentProfileRequest
  ): zio.aws.datazone.model.UpdateEnvironmentProfileRequest.ReadOnly =
    new Wrapper(impl)
}
