package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait TypesSearchScope {
  def unwrap: software.amazon.awssdk.services.datazone.model.TypesSearchScope
}
object TypesSearchScope {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.TypesSearchScope
  ): zio.aws.datazone.model.TypesSearchScope = value match {
    case software.amazon.awssdk.services.datazone.model.TypesSearchScope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.TypesSearchScope.ASSET_TYPE =>
      val r = ASSET_TYPE
      r
    case software.amazon.awssdk.services.datazone.model.TypesSearchScope.FORM_TYPE =>
      val r = FORM_TYPE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.TypesSearchScope {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.TypesSearchScope =
      software.amazon.awssdk.services.datazone.model.TypesSearchScope.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSET_TYPE extends zio.aws.datazone.model.TypesSearchScope {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.TypesSearchScope =
      software.amazon.awssdk.services.datazone.model.TypesSearchScope.ASSET_TYPE
  }
  case object FORM_TYPE extends zio.aws.datazone.model.TypesSearchScope {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.TypesSearchScope =
      software.amazon.awssdk.services.datazone.model.TypesSearchScope.FORM_TYPE
  }
}
