package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  ProjectId,
  Revision,
  Description,
  ListingName,
  ListingId
}
import scala.jdk.CollectionConverters._
final case class SubscribedListing(
    description: Description,
    id: ListingId,
    item: zio.aws.datazone.model.SubscribedListingItem,
    name: ListingName,
    ownerProjectId: ProjectId,
    ownerProjectName: Optional[String] = Optional.Absent,
    revision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.SubscribedListing = {
    import SubscribedListing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.SubscribedListing
      .builder()
      .description(Description.unwrap(description): java.lang.String)
      .id(ListingId.unwrap(id): java.lang.String)
      .item(item.buildAwsValue())
      .name(ListingName.unwrap(name): java.lang.String)
      .ownerProjectId(ProjectId.unwrap(ownerProjectId): java.lang.String)
      .optionallyWith(ownerProjectName.map(value => value: java.lang.String))(
        _.ownerProjectName
      )
      .optionallyWith(
        revision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.revision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.SubscribedListing.ReadOnly =
    zio.aws.datazone.model.SubscribedListing.wrap(buildAwsValue())
}
object SubscribedListing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.SubscribedListing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.SubscribedListing =
      zio.aws.datazone.model.SubscribedListing(
        description,
        id,
        item.asEditable,
        name,
        ownerProjectId,
        ownerProjectName.map(value => value),
        revision.map(value => value)
      )
    def description: Description
    def id: ListingId
    def item: zio.aws.datazone.model.SubscribedListingItem.ReadOnly
    def name: ListingName
    def ownerProjectId: ProjectId
    def ownerProjectName: Optional[String]
    def revision: Optional[Revision]
    def getDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(description)
    def getId: ZIO[Any, Nothing, ListingId] = ZIO.succeed(id)
    def getItem: ZIO[
      Any,
      Nothing,
      zio.aws.datazone.model.SubscribedListingItem.ReadOnly
    ] = ZIO.succeed(item)
    def getName: ZIO[Any, Nothing, ListingName] = ZIO.succeed(name)
    def getOwnerProjectId: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(ownerProjectId)
    def getOwnerProjectName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerProjectName", ownerProjectName)
    def getRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedListing
  ) extends zio.aws.datazone.model.SubscribedListing.ReadOnly {
    override val description: Description =
      zio.aws.datazone.model.primitives.Description(impl.description())
    override val id: ListingId =
      zio.aws.datazone.model.primitives.ListingId(impl.id())
    override val item: zio.aws.datazone.model.SubscribedListingItem.ReadOnly =
      zio.aws.datazone.model.SubscribedListingItem.wrap(impl.item())
    override val name: ListingName =
      zio.aws.datazone.model.primitives.ListingName(impl.name())
    override val ownerProjectId: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.ownerProjectId())
    override val ownerProjectName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerProjectName())
      .map(value => value: String)
    override val revision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.SubscribedListing
  ): zio.aws.datazone.model.SubscribedListing.ReadOnly = new Wrapper(impl)
}
