package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RedshiftStorage(
    redshiftClusterSource: Optional[
      zio.aws.datazone.model.RedshiftClusterStorage
    ] = Optional.Absent,
    redshiftServerlessSource: Optional[
      zio.aws.datazone.model.RedshiftServerlessStorage
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RedshiftStorage = {
    import RedshiftStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RedshiftStorage
      .builder()
      .optionallyWith(
        redshiftClusterSource.map(value => value.buildAwsValue())
      )(_.redshiftClusterSource)
      .optionallyWith(
        redshiftServerlessSource.map(value => value.buildAwsValue())
      )(_.redshiftServerlessSource)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RedshiftStorage.ReadOnly =
    zio.aws.datazone.model.RedshiftStorage.wrap(buildAwsValue())
}
object RedshiftStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RedshiftStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RedshiftStorage =
      zio.aws.datazone.model.RedshiftStorage(
        redshiftClusterSource.map(value => value.asEditable),
        redshiftServerlessSource.map(value => value.asEditable)
      )
    def redshiftClusterSource
        : Optional[zio.aws.datazone.model.RedshiftClusterStorage.ReadOnly]
    def redshiftServerlessSource
        : Optional[zio.aws.datazone.model.RedshiftServerlessStorage.ReadOnly]
    def getRedshiftClusterSource: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.RedshiftClusterStorage.ReadOnly
    ] =
      AwsError.unwrapOptionField("redshiftClusterSource", redshiftClusterSource)
    def getRedshiftServerlessSource: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.RedshiftServerlessStorage.ReadOnly
    ] = AwsError.unwrapOptionField(
      "redshiftServerlessSource",
      redshiftServerlessSource
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftStorage
  ) extends zio.aws.datazone.model.RedshiftStorage.ReadOnly {
    override val redshiftClusterSource
        : Optional[zio.aws.datazone.model.RedshiftClusterStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redshiftClusterSource())
        .map(value => zio.aws.datazone.model.RedshiftClusterStorage.wrap(value))
    override val redshiftServerlessSource
        : Optional[zio.aws.datazone.model.RedshiftServerlessStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redshiftServerlessSource())
        .map(value =>
          zio.aws.datazone.model.RedshiftServerlessStorage.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftStorage
  ): zio.aws.datazone.model.RedshiftStorage.ReadOnly = new Wrapper(impl)
}
