package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  RedshiftRunConfigurationOutputRegionString,
  RedshiftRunConfigurationOutputDataAccessRoleString,
  RedshiftRunConfigurationOutputAccountIdString
}
import scala.jdk.CollectionConverters._
final case class RedshiftRunConfigurationOutput(
    accountId: Optional[RedshiftRunConfigurationOutputAccountIdString] =
      Optional.Absent,
    dataAccessRole: Optional[
      RedshiftRunConfigurationOutputDataAccessRoleString
    ] = Optional.Absent,
    redshiftCredentialConfiguration: zio.aws.datazone.model.RedshiftCredentialConfiguration,
    redshiftStorage: zio.aws.datazone.model.RedshiftStorage,
    region: Optional[RedshiftRunConfigurationOutputRegionString] =
      Optional.Absent,
    relationalFilterConfigurations: Iterable[
      zio.aws.datazone.model.RelationalFilterConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationOutput = {
    import RedshiftRunConfigurationOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationOutput
      .builder()
      .optionallyWith(
        accountId.map(value =>
          RedshiftRunConfigurationOutputAccountIdString.unwrap(
            value
          ): java.lang.String
        )
      )(_.accountId)
      .optionallyWith(
        dataAccessRole.map(value =>
          RedshiftRunConfigurationOutputDataAccessRoleString.unwrap(
            value
          ): java.lang.String
        )
      )(_.dataAccessRole)
      .redshiftCredentialConfiguration(
        redshiftCredentialConfiguration.buildAwsValue()
      )
      .redshiftStorage(redshiftStorage.buildAwsValue())
      .optionallyWith(
        region.map(value =>
          RedshiftRunConfigurationOutputRegionString.unwrap(
            value
          ): java.lang.String
        )
      )(_.region)
      .relationalFilterConfigurations(relationalFilterConfigurations.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.RedshiftRunConfigurationOutput.ReadOnly =
    zio.aws.datazone.model.RedshiftRunConfigurationOutput.wrap(buildAwsValue())
}
object RedshiftRunConfigurationOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RedshiftRunConfigurationOutput =
      zio.aws.datazone.model.RedshiftRunConfigurationOutput(
        accountId.map(value => value),
        dataAccessRole.map(value => value),
        redshiftCredentialConfiguration.asEditable,
        redshiftStorage.asEditable,
        region.map(value => value),
        relationalFilterConfigurations.map { item =>
          item.asEditable
        }
      )
    def accountId: Optional[RedshiftRunConfigurationOutputAccountIdString]
    def dataAccessRole
        : Optional[RedshiftRunConfigurationOutputDataAccessRoleString]
    def redshiftCredentialConfiguration
        : zio.aws.datazone.model.RedshiftCredentialConfiguration.ReadOnly
    def redshiftStorage: zio.aws.datazone.model.RedshiftStorage.ReadOnly
    def region: Optional[RedshiftRunConfigurationOutputRegionString]
    def relationalFilterConfigurations
        : List[zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly]
    def getAccountId
        : ZIO[Any, AwsError, RedshiftRunConfigurationOutputAccountIdString] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getDataAccessRole: ZIO[
      Any,
      AwsError,
      RedshiftRunConfigurationOutputDataAccessRoleString
    ] = AwsError.unwrapOptionField("dataAccessRole", dataAccessRole)
    def getRedshiftCredentialConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.datazone.model.RedshiftCredentialConfiguration.ReadOnly
    ] = ZIO.succeed(redshiftCredentialConfiguration)
    def getRedshiftStorage
        : ZIO[Any, Nothing, zio.aws.datazone.model.RedshiftStorage.ReadOnly] =
      ZIO.succeed(redshiftStorage)
    def getRegion
        : ZIO[Any, AwsError, RedshiftRunConfigurationOutputRegionString] =
      AwsError.unwrapOptionField("region", region)
    def getRelationalFilterConfigurations: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly
    ]] = ZIO.succeed(relationalFilterConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationOutput
  ) extends zio.aws.datazone.model.RedshiftRunConfigurationOutput.ReadOnly {
    override val accountId
        : Optional[RedshiftRunConfigurationOutputAccountIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountId())
        .map(value =>
          zio.aws.datazone.model.primitives
            .RedshiftRunConfigurationOutputAccountIdString(value)
        )
    override val dataAccessRole
        : Optional[RedshiftRunConfigurationOutputDataAccessRoleString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataAccessRole())
        .map(value =>
          zio.aws.datazone.model.primitives
            .RedshiftRunConfigurationOutputDataAccessRoleString(value)
        )
    override val redshiftCredentialConfiguration
        : zio.aws.datazone.model.RedshiftCredentialConfiguration.ReadOnly =
      zio.aws.datazone.model.RedshiftCredentialConfiguration
        .wrap(impl.redshiftCredentialConfiguration())
    override val redshiftStorage
        : zio.aws.datazone.model.RedshiftStorage.ReadOnly =
      zio.aws.datazone.model.RedshiftStorage.wrap(impl.redshiftStorage())
    override val region: Optional[RedshiftRunConfigurationOutputRegionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.region())
        .map(value =>
          zio.aws.datazone.model.primitives
            .RedshiftRunConfigurationOutputRegionString(value)
        )
    override val relationalFilterConfigurations
        : List[zio.aws.datazone.model.RelationalFilterConfiguration.ReadOnly] =
      impl
        .relationalFilterConfigurations()
        .asScala
        .map { item =>
          zio.aws.datazone.model.RelationalFilterConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RedshiftRunConfigurationOutput
  ): zio.aws.datazone.model.RedshiftRunConfigurationOutput.ReadOnly =
    new Wrapper(impl)
}
