package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait NotificationRole {
  def unwrap: software.amazon.awssdk.services.datazone.model.NotificationRole
}
object NotificationRole {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.NotificationRole
  ): zio.aws.datazone.model.NotificationRole = value match {
    case software.amazon.awssdk.services.datazone.model.NotificationRole.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.NotificationRole.PROJECT_OWNER =>
      val r = PROJECT_OWNER
      r
    case software.amazon.awssdk.services.datazone.model.NotificationRole.PROJECT_CONTRIBUTOR =>
      val r = PROJECT_CONTRIBUTOR
      r
    case software.amazon.awssdk.services.datazone.model.NotificationRole.PROJECT_VIEWER =>
      val r = PROJECT_VIEWER
      r
    case software.amazon.awssdk.services.datazone.model.NotificationRole.DOMAIN_OWNER =>
      val r = DOMAIN_OWNER
      r
    case software.amazon.awssdk.services.datazone.model.NotificationRole.PROJECT_SUBSCRIBER =>
      val r = PROJECT_SUBSCRIBER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.NotificationRole {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationRole =
      software.amazon.awssdk.services.datazone.model.NotificationRole.UNKNOWN_TO_SDK_VERSION
  }
  case object PROJECT_OWNER extends zio.aws.datazone.model.NotificationRole {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationRole =
      software.amazon.awssdk.services.datazone.model.NotificationRole.PROJECT_OWNER
  }
  case object PROJECT_CONTRIBUTOR
      extends zio.aws.datazone.model.NotificationRole {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationRole =
      software.amazon.awssdk.services.datazone.model.NotificationRole.PROJECT_CONTRIBUTOR
  }
  case object PROJECT_VIEWER extends zio.aws.datazone.model.NotificationRole {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationRole =
      software.amazon.awssdk.services.datazone.model.NotificationRole.PROJECT_VIEWER
  }
  case object DOMAIN_OWNER extends zio.aws.datazone.model.NotificationRole {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationRole =
      software.amazon.awssdk.services.datazone.model.NotificationRole.DOMAIN_OWNER
  }
  case object PROJECT_SUBSCRIBER
      extends zio.aws.datazone.model.NotificationRole {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.NotificationRole =
      software.amazon.awssdk.services.datazone.model.NotificationRole.PROJECT_SUBSCRIBER
  }
}
