package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GrantedEntityInput(
    listing: Optional[zio.aws.datazone.model.ListingRevisionInput] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GrantedEntityInput = {
    import GrantedEntityInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GrantedEntityInput
      .builder()
      .optionallyWith(listing.map(value => value.buildAwsValue()))(_.listing)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GrantedEntityInput.ReadOnly =
    zio.aws.datazone.model.GrantedEntityInput.wrap(buildAwsValue())
}
object GrantedEntityInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GrantedEntityInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GrantedEntityInput =
      zio.aws.datazone.model
        .GrantedEntityInput(listing.map(value => value.asEditable))
    def listing: Optional[zio.aws.datazone.model.ListingRevisionInput.ReadOnly]
    def getListing: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.ListingRevisionInput.ReadOnly
    ] = AwsError.unwrapOptionField("listing", listing)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GrantedEntityInput
  ) extends zio.aws.datazone.model.GrantedEntityInput.ReadOnly {
    override val listing
        : Optional[zio.aws.datazone.model.ListingRevisionInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listing())
        .map(value => zio.aws.datazone.model.ListingRevisionInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GrantedEntityInput
  ): zio.aws.datazone.model.GrantedEntityInput.ReadOnly = new Wrapper(impl)
}
