package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  LongDescription,
  GlossaryTermId,
  UpdatedBy,
  CreatedAt,
  DomainId,
  GlossaryId,
  ShortDescription,
  CreatedBy,
  UpdatedAt,
  GlossaryTermName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GlossaryTermItem(
    createdAt: Optional[CreatedAt] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    domainId: DomainId,
    glossaryId: GlossaryId,
    id: GlossaryTermId,
    longDescription: Optional[LongDescription] = Optional.Absent,
    name: GlossaryTermName,
    shortDescription: Optional[ShortDescription] = Optional.Absent,
    status: zio.aws.datazone.model.GlossaryTermStatus,
    termRelations: Optional[zio.aws.datazone.model.TermRelations] =
      Optional.Absent,
    updatedAt: Optional[UpdatedAt] = Optional.Absent,
    updatedBy: Optional[UpdatedBy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GlossaryTermItem = {
    import GlossaryTermItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GlossaryTermItem
      .builder()
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .glossaryId(GlossaryId.unwrap(glossaryId): java.lang.String)
      .id(GlossaryTermId.unwrap(id): java.lang.String)
      .optionallyWith(
        longDescription.map(value =>
          LongDescription.unwrap(value): java.lang.String
        )
      )(_.longDescription)
      .name(GlossaryTermName.unwrap(name): java.lang.String)
      .optionallyWith(
        shortDescription.map(value =>
          ShortDescription.unwrap(value): java.lang.String
        )
      )(_.shortDescription)
      .status(status.unwrap)
      .optionallyWith(termRelations.map(value => value.buildAwsValue()))(
        _.termRelations
      )
      .optionallyWith(updatedAt.map(value => UpdatedAt.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        updatedBy.map(value => UpdatedBy.unwrap(value): java.lang.String)
      )(_.updatedBy)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GlossaryTermItem.ReadOnly =
    zio.aws.datazone.model.GlossaryTermItem.wrap(buildAwsValue())
}
object GlossaryTermItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GlossaryTermItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GlossaryTermItem =
      zio.aws.datazone.model.GlossaryTermItem(
        createdAt.map(value => value),
        createdBy.map(value => value),
        domainId,
        glossaryId,
        id,
        longDescription.map(value => value),
        name,
        shortDescription.map(value => value),
        status,
        termRelations.map(value => value.asEditable),
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def createdAt: Optional[CreatedAt]
    def createdBy: Optional[CreatedBy]
    def domainId: DomainId
    def glossaryId: GlossaryId
    def id: GlossaryTermId
    def longDescription: Optional[LongDescription]
    def name: GlossaryTermName
    def shortDescription: Optional[ShortDescription]
    def status: zio.aws.datazone.model.GlossaryTermStatus
    def termRelations: Optional[zio.aws.datazone.model.TermRelations.ReadOnly]
    def updatedAt: Optional[UpdatedAt]
    def updatedBy: Optional[UpdatedBy]
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getGlossaryId: ZIO[Any, Nothing, GlossaryId] = ZIO.succeed(glossaryId)
    def getId: ZIO[Any, Nothing, GlossaryTermId] = ZIO.succeed(id)
    def getLongDescription: ZIO[Any, AwsError, LongDescription] =
      AwsError.unwrapOptionField("longDescription", longDescription)
    def getName: ZIO[Any, Nothing, GlossaryTermName] = ZIO.succeed(name)
    def getShortDescription: ZIO[Any, AwsError, ShortDescription] =
      AwsError.unwrapOptionField("shortDescription", shortDescription)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.datazone.model.GlossaryTermStatus] =
      ZIO.succeed(status)
    def getTermRelations
        : ZIO[Any, AwsError, zio.aws.datazone.model.TermRelations.ReadOnly] =
      AwsError.unwrapOptionField("termRelations", termRelations)
    def getUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, UpdatedBy] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GlossaryTermItem
  ) extends zio.aws.datazone.model.GlossaryTermItem.ReadOnly {
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val glossaryId: GlossaryId =
      zio.aws.datazone.model.primitives.GlossaryId(impl.glossaryId())
    override val id: GlossaryTermId =
      zio.aws.datazone.model.primitives.GlossaryTermId(impl.id())
    override val longDescription: Optional[LongDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.longDescription())
        .map(value => zio.aws.datazone.model.primitives.LongDescription(value))
    override val name: GlossaryTermName =
      zio.aws.datazone.model.primitives.GlossaryTermName(impl.name())
    override val shortDescription: Optional[ShortDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shortDescription())
        .map(value => zio.aws.datazone.model.primitives.ShortDescription(value))
    override val status: zio.aws.datazone.model.GlossaryTermStatus =
      zio.aws.datazone.model.GlossaryTermStatus.wrap(impl.status())
    override val termRelations
        : Optional[zio.aws.datazone.model.TermRelations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.termRelations())
        .map(value => zio.aws.datazone.model.TermRelations.wrap(value))
    override val updatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.datazone.model.primitives.UpdatedAt(value))
    override val updatedBy: Optional[UpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedBy())
      .map(value => zio.aws.datazone.model.primitives.UpdatedBy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GlossaryTermItem
  ): zio.aws.datazone.model.GlossaryTermItem.ReadOnly = new Wrapper(impl)
}
