package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  AssetName,
  GlossaryTermId,
  AssetIdentifier,
  DomainId,
  Revision,
  Description,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class CreateAssetRevisionRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainIdentifier: DomainId,
    formsInput: Optional[Iterable[zio.aws.datazone.model.FormInput]] =
      Optional.Absent,
    glossaryTerms: Optional[Iterable[GlossaryTermId]] = Optional.Absent,
    identifier: AssetIdentifier,
    name: AssetName,
    predictionConfiguration: Optional[
      zio.aws.datazone.model.PredictionConfiguration
    ] = Optional.Absent,
    typeRevision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest = {
    import CreateAssetRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        formsInput.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.formsInput)
      .optionallyWith(
        glossaryTerms.map(value =>
          value.map { item =>
            GlossaryTermId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.glossaryTerms)
      .identifier(AssetIdentifier.unwrap(identifier): java.lang.String)
      .name(AssetName.unwrap(name): java.lang.String)
      .optionallyWith(
        predictionConfiguration.map(value => value.buildAwsValue())
      )(_.predictionConfiguration)
      .optionallyWith(
        typeRevision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.typeRevision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateAssetRevisionRequest.ReadOnly =
    zio.aws.datazone.model.CreateAssetRevisionRequest.wrap(buildAwsValue())
}
object CreateAssetRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateAssetRevisionRequest =
      zio.aws.datazone.model.CreateAssetRevisionRequest(
        clientToken.map(value => value),
        description.map(value => value),
        domainIdentifier,
        formsInput.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        glossaryTerms.map(value => value),
        identifier,
        name,
        predictionConfiguration.map(value => value.asEditable),
        typeRevision.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[Description]
    def domainIdentifier: DomainId
    def formsInput: Optional[List[zio.aws.datazone.model.FormInput.ReadOnly]]
    def glossaryTerms: Optional[List[GlossaryTermId]]
    def identifier: AssetIdentifier
    def name: AssetName
    def predictionConfiguration
        : Optional[zio.aws.datazone.model.PredictionConfiguration.ReadOnly]
    def typeRevision: Optional[Revision]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getFormsInput
        : ZIO[Any, AwsError, List[zio.aws.datazone.model.FormInput.ReadOnly]] =
      AwsError.unwrapOptionField("formsInput", formsInput)
    def getGlossaryTerms: ZIO[Any, AwsError, List[GlossaryTermId]] =
      AwsError.unwrapOptionField("glossaryTerms", glossaryTerms)
    def getIdentifier: ZIO[Any, Nothing, AssetIdentifier] =
      ZIO.succeed(identifier)
    def getName: ZIO[Any, Nothing, AssetName] = ZIO.succeed(name)
    def getPredictionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datazone.model.PredictionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "predictionConfiguration",
      predictionConfiguration
    )
    def getTypeRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("typeRevision", typeRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest
  ) extends zio.aws.datazone.model.CreateAssetRevisionRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.datazone.model.primitives.ClientToken(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val formsInput
        : Optional[List[zio.aws.datazone.model.FormInput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formsInput())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.FormInput.wrap(item)
          }.toList
        )
    override val glossaryTerms: Optional[List[GlossaryTermId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.glossaryTerms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.primitives.GlossaryTermId(item)
          }.toList
        )
    override val identifier: AssetIdentifier =
      zio.aws.datazone.model.primitives.AssetIdentifier(impl.identifier())
    override val name: AssetName =
      zio.aws.datazone.model.primitives.AssetName(impl.name())
    override val predictionConfiguration
        : Optional[zio.aws.datazone.model.PredictionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictionConfiguration())
        .map(value =>
          zio.aws.datazone.model.PredictionConfiguration.wrap(value)
        )
    override val typeRevision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.typeRevision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateAssetRevisionRequest
  ): zio.aws.datazone.model.CreateAssetRevisionRequest.ReadOnly = new Wrapper(
    impl
  )
}
