package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait ConfigurableActionTypeAuthorization {
  def unwrap: software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization
}
object ConfigurableActionTypeAuthorization {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization
  ): zio.aws.datazone.model.ConfigurableActionTypeAuthorization = value match {
    case software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization.IAM =>
      val r = IAM
      r
    case software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization.HTTPS =>
      val r = HTTPS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.ConfigurableActionTypeAuthorization {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization =
      software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization.UNKNOWN_TO_SDK_VERSION
  }
  case object IAM
      extends zio.aws.datazone.model.ConfigurableActionTypeAuthorization {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization =
      software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization.IAM
  }
  case object HTTPS
      extends zio.aws.datazone.model.ConfigurableActionTypeAuthorization {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization =
      software.amazon.awssdk.services.datazone.model.ConfigurableActionTypeAuthorization.HTTPS
  }
}
