package zio.aws.datazone.model
import scala.jdk.CollectionConverters._
sealed trait UserProfileType {
  def unwrap: software.amazon.awssdk.services.datazone.model.UserProfileType
}
object UserProfileType {
  def wrap(
      value: software.amazon.awssdk.services.datazone.model.UserProfileType
  ): zio.aws.datazone.model.UserProfileType = value match {
    case software.amazon.awssdk.services.datazone.model.UserProfileType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datazone.model.UserProfileType.IAM =>
      val r = IAM
      r
    case software.amazon.awssdk.services.datazone.model.UserProfileType.SSO =>
      val r = SSO
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datazone.model.UserProfileType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserProfileType =
      software.amazon.awssdk.services.datazone.model.UserProfileType.UNKNOWN_TO_SDK_VERSION
  }
  case object IAM extends zio.aws.datazone.model.UserProfileType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserProfileType =
      software.amazon.awssdk.services.datazone.model.UserProfileType.IAM
  }
  case object SSO extends zio.aws.datazone.model.UserProfileType {
    override def unwrap
        : software.amazon.awssdk.services.datazone.model.UserProfileType =
      software.amazon.awssdk.services.datazone.model.UserProfileType.SSO
  }
}
