package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  Revision,
  AssetIdentifier,
  DomainId,
  ClientToken
}
import scala.jdk.CollectionConverters._
final case class RejectPredictionsRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    domainIdentifier: DomainId,
    identifier: AssetIdentifier,
    rejectChoices: Optional[Iterable[zio.aws.datazone.model.RejectChoice]] =
      Optional.Absent,
    rejectRule: Optional[zio.aws.datazone.model.RejectRule] = Optional.Absent,
    revision: Optional[Revision] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest = {
    import RejectPredictionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(AssetIdentifier.unwrap(identifier): java.lang.String)
      .optionallyWith(
        rejectChoices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rejectChoices)
      .optionallyWith(rejectRule.map(value => value.buildAwsValue()))(
        _.rejectRule
      )
      .optionallyWith(
        revision.map(value => Revision.unwrap(value): java.lang.String)
      )(_.revision)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.RejectPredictionsRequest.ReadOnly =
    zio.aws.datazone.model.RejectPredictionsRequest.wrap(buildAwsValue())
}
object RejectPredictionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.RejectPredictionsRequest =
      zio.aws.datazone.model.RejectPredictionsRequest(
        clientToken.map(value => value),
        domainIdentifier,
        identifier,
        rejectChoices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        rejectRule.map(value => value.asEditable),
        revision.map(value => value)
      )
    def clientToken: Optional[ClientToken]
    def domainIdentifier: DomainId
    def identifier: AssetIdentifier
    def rejectChoices
        : Optional[List[zio.aws.datazone.model.RejectChoice.ReadOnly]]
    def rejectRule: Optional[zio.aws.datazone.model.RejectRule.ReadOnly]
    def revision: Optional[Revision]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, AssetIdentifier] =
      ZIO.succeed(identifier)
    def getRejectChoices: ZIO[Any, AwsError, List[
      zio.aws.datazone.model.RejectChoice.ReadOnly
    ]] = AwsError.unwrapOptionField("rejectChoices", rejectChoices)
    def getRejectRule
        : ZIO[Any, AwsError, zio.aws.datazone.model.RejectRule.ReadOnly] =
      AwsError.unwrapOptionField("rejectRule", rejectRule)
    def getRevision: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest
  ) extends zio.aws.datazone.model.RejectPredictionsRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.datazone.model.primitives.ClientToken(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: AssetIdentifier =
      zio.aws.datazone.model.primitives.AssetIdentifier(impl.identifier())
    override val rejectChoices
        : Optional[List[zio.aws.datazone.model.RejectChoice.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rejectChoices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.RejectChoice.wrap(item)
          }.toList
        )
    override val rejectRule
        : Optional[zio.aws.datazone.model.RejectRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rejectRule())
        .map(value => zio.aws.datazone.model.RejectRule.wrap(value))
    override val revision: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => zio.aws.datazone.model.primitives.Revision(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.RejectPredictionsRequest
  ): zio.aws.datazone.model.RejectPredictionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
