package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListEnvironmentBlueprintsResponse(
    items: Iterable[zio.aws.datazone.model.EnvironmentBlueprintSummary],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse = {
    import ListEnvironmentBlueprintsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.ListEnvironmentBlueprintsResponse.ReadOnly =
    zio.aws.datazone.model.ListEnvironmentBlueprintsResponse
      .wrap(buildAwsValue())
}
object ListEnvironmentBlueprintsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListEnvironmentBlueprintsResponse =
      zio.aws.datazone.model.ListEnvironmentBlueprintsResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly
    ]] = ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse
  ) extends zio.aws.datazone.model.ListEnvironmentBlueprintsResponse.ReadOnly {
    override val items
        : List[zio.aws.datazone.model.EnvironmentBlueprintSummary.ReadOnly] =
      impl
        .items()
        .asScala
        .map { item =>
          zio.aws.datazone.model.EnvironmentBlueprintSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse
  ): zio.aws.datazone.model.ListEnvironmentBlueprintsResponse.ReadOnly =
    new Wrapper(impl)
}
