package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.datazone.model.primitives.{ProjectId, DomainId}
import scala.jdk.CollectionConverters._
final case class GetProjectRequest(
    domainIdentifier: DomainId,
    identifier: ProjectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.GetProjectRequest = {
    import GetProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.GetProjectRequest
      .builder()
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(ProjectId.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.GetProjectRequest.ReadOnly =
    zio.aws.datazone.model.GetProjectRequest.wrap(buildAwsValue())
}
object GetProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.GetProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.GetProjectRequest =
      zio.aws.datazone.model.GetProjectRequest(domainIdentifier, identifier)
    def domainIdentifier: DomainId
    def identifier: ProjectId
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.GetProjectRequest
  ) extends zio.aws.datazone.model.GetProjectRequest.ReadOnly {
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: ProjectId =
      zio.aws.datazone.model.primitives.ProjectId(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.GetProjectRequest
  ): zio.aws.datazone.model.GetProjectRequest.ReadOnly = new Wrapper(impl)
}
