package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  DeploymentPropertiesStartTimeoutMinutesInteger,
  DeploymentPropertiesEndTimeoutMinutesInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DeploymentProperties(
    endTimeoutMinutes: Optional[DeploymentPropertiesEndTimeoutMinutesInteger] =
      Optional.Absent,
    startTimeoutMinutes: Optional[
      DeploymentPropertiesStartTimeoutMinutesInteger
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.DeploymentProperties = {
    import DeploymentProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.DeploymentProperties
      .builder()
      .optionallyWith(
        endTimeoutMinutes.map(value =>
          DeploymentPropertiesEndTimeoutMinutesInteger.unwrap(value): Integer
        )
      )(_.endTimeoutMinutes)
      .optionallyWith(
        startTimeoutMinutes.map(value =>
          DeploymentPropertiesStartTimeoutMinutesInteger.unwrap(value): Integer
        )
      )(_.startTimeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.DeploymentProperties.ReadOnly =
    zio.aws.datazone.model.DeploymentProperties.wrap(buildAwsValue())
}
object DeploymentProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.DeploymentProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.DeploymentProperties =
      zio.aws.datazone.model.DeploymentProperties(
        endTimeoutMinutes.map(value => value),
        startTimeoutMinutes.map(value => value)
      )
    def endTimeoutMinutes
        : Optional[DeploymentPropertiesEndTimeoutMinutesInteger]
    def startTimeoutMinutes
        : Optional[DeploymentPropertiesStartTimeoutMinutesInteger]
    def getEndTimeoutMinutes
        : ZIO[Any, AwsError, DeploymentPropertiesEndTimeoutMinutesInteger] =
      AwsError.unwrapOptionField("endTimeoutMinutes", endTimeoutMinutes)
    def getStartTimeoutMinutes
        : ZIO[Any, AwsError, DeploymentPropertiesStartTimeoutMinutesInteger] =
      AwsError.unwrapOptionField("startTimeoutMinutes", startTimeoutMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.DeploymentProperties
  ) extends zio.aws.datazone.model.DeploymentProperties.ReadOnly {
    override val endTimeoutMinutes
        : Optional[DeploymentPropertiesEndTimeoutMinutesInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endTimeoutMinutes())
        .map(value =>
          zio.aws.datazone.model.primitives
            .DeploymentPropertiesEndTimeoutMinutesInteger(value)
        )
    override val startTimeoutMinutes
        : Optional[DeploymentPropertiesStartTimeoutMinutesInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTimeoutMinutes())
        .map(value =>
          zio.aws.datazone.model.primitives
            .DeploymentPropertiesStartTimeoutMinutesInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.DeploymentProperties
  ): zio.aws.datazone.model.DeploymentProperties.ReadOnly = new Wrapper(impl)
}
