package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{RequestReason, DomainId}
import scala.jdk.CollectionConverters._
final case class CreateSubscriptionRequestRequest(
    clientToken: Optional[String] = Optional.Absent,
    domainIdentifier: DomainId,
    requestReason: RequestReason,
    subscribedListings: Iterable[zio.aws.datazone.model.SubscribedListingInput],
    subscribedPrincipals: Iterable[
      zio.aws.datazone.model.SubscribedPrincipalInput
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest = {
    import CreateSubscriptionRequestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .requestReason(RequestReason.unwrap(requestReason): java.lang.String)
      .subscribedListings(subscribedListings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .subscribedPrincipals(subscribedPrincipals.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.datazone.model.CreateSubscriptionRequestRequest.ReadOnly =
    zio.aws.datazone.model.CreateSubscriptionRequestRequest
      .wrap(buildAwsValue())
}
object CreateSubscriptionRequestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateSubscriptionRequestRequest =
      zio.aws.datazone.model.CreateSubscriptionRequestRequest(
        clientToken.map(value => value),
        domainIdentifier,
        requestReason,
        subscribedListings.map { item =>
          item.asEditable
        },
        subscribedPrincipals.map { item =>
          item.asEditable
        }
      )
    def clientToken: Optional[String]
    def domainIdentifier: DomainId
    def requestReason: RequestReason
    def subscribedListings
        : List[zio.aws.datazone.model.SubscribedListingInput.ReadOnly]
    def subscribedPrincipals
        : List[zio.aws.datazone.model.SubscribedPrincipalInput.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getRequestReason: ZIO[Any, Nothing, RequestReason] =
      ZIO.succeed(requestReason)
    def getSubscribedListings: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.SubscribedListingInput.ReadOnly
    ]] = ZIO.succeed(subscribedListings)
    def getSubscribedPrincipals: ZIO[Any, Nothing, List[
      zio.aws.datazone.model.SubscribedPrincipalInput.ReadOnly
    ]] = ZIO.succeed(subscribedPrincipals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest
  ) extends zio.aws.datazone.model.CreateSubscriptionRequestRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val requestReason: RequestReason =
      zio.aws.datazone.model.primitives.RequestReason(impl.requestReason())
    override val subscribedListings
        : List[zio.aws.datazone.model.SubscribedListingInput.ReadOnly] = impl
      .subscribedListings()
      .asScala
      .map { item =>
        zio.aws.datazone.model.SubscribedListingInput.wrap(item)
      }
      .toList
    override val subscribedPrincipals
        : List[zio.aws.datazone.model.SubscribedPrincipalInput.ReadOnly] = impl
      .subscribedPrincipals()
      .asScala
      .map { item =>
        zio.aws.datazone.model.SubscribedPrincipalInput.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateSubscriptionRequestRequest
  ): zio.aws.datazone.model.CreateSubscriptionRequestRequest.ReadOnly =
    new Wrapper(impl)
}
