package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  LongDescription,
  GlossaryTermId,
  DomainId,
  ShortDescription,
  ClientToken,
  GlossaryTermName
}
import scala.jdk.CollectionConverters._
final case class CreateGlossaryTermRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    domainIdentifier: DomainId,
    glossaryIdentifier: GlossaryTermId,
    longDescription: Optional[LongDescription] = Optional.Absent,
    name: GlossaryTermName,
    shortDescription: Optional[ShortDescription] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.GlossaryTermStatus] =
      Optional.Absent,
    termRelations: Optional[zio.aws.datazone.model.TermRelations] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest = {
    import CreateGlossaryTermRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .glossaryIdentifier(
        GlossaryTermId.unwrap(glossaryIdentifier): java.lang.String
      )
      .optionallyWith(
        longDescription.map(value =>
          LongDescription.unwrap(value): java.lang.String
        )
      )(_.longDescription)
      .name(GlossaryTermName.unwrap(name): java.lang.String)
      .optionallyWith(
        shortDescription.map(value =>
          ShortDescription.unwrap(value): java.lang.String
        )
      )(_.shortDescription)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(termRelations.map(value => value.buildAwsValue()))(
        _.termRelations
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateGlossaryTermRequest.ReadOnly =
    zio.aws.datazone.model.CreateGlossaryTermRequest.wrap(buildAwsValue())
}
object CreateGlossaryTermRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateGlossaryTermRequest =
      zio.aws.datazone.model.CreateGlossaryTermRequest(
        clientToken.map(value => value),
        domainIdentifier,
        glossaryIdentifier,
        longDescription.map(value => value),
        name,
        shortDescription.map(value => value),
        status.map(value => value),
        termRelations.map(value => value.asEditable)
      )
    def clientToken: Optional[ClientToken]
    def domainIdentifier: DomainId
    def glossaryIdentifier: GlossaryTermId
    def longDescription: Optional[LongDescription]
    def name: GlossaryTermName
    def shortDescription: Optional[ShortDescription]
    def status: Optional[zio.aws.datazone.model.GlossaryTermStatus]
    def termRelations: Optional[zio.aws.datazone.model.TermRelations.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getGlossaryIdentifier: ZIO[Any, Nothing, GlossaryTermId] =
      ZIO.succeed(glossaryIdentifier)
    def getLongDescription: ZIO[Any, AwsError, LongDescription] =
      AwsError.unwrapOptionField("longDescription", longDescription)
    def getName: ZIO[Any, Nothing, GlossaryTermName] = ZIO.succeed(name)
    def getShortDescription: ZIO[Any, AwsError, ShortDescription] =
      AwsError.unwrapOptionField("shortDescription", shortDescription)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.GlossaryTermStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTermRelations
        : ZIO[Any, AwsError, zio.aws.datazone.model.TermRelations.ReadOnly] =
      AwsError.unwrapOptionField("termRelations", termRelations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest
  ) extends zio.aws.datazone.model.CreateGlossaryTermRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.datazone.model.primitives.ClientToken(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val glossaryIdentifier: GlossaryTermId =
      zio.aws.datazone.model.primitives
        .GlossaryTermId(impl.glossaryIdentifier())
    override val longDescription: Optional[LongDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.longDescription())
        .map(value => zio.aws.datazone.model.primitives.LongDescription(value))
    override val name: GlossaryTermName =
      zio.aws.datazone.model.primitives.GlossaryTermName(impl.name())
    override val shortDescription: Optional[ShortDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shortDescription())
        .map(value => zio.aws.datazone.model.primitives.ShortDescription(value))
    override val status: Optional[zio.aws.datazone.model.GlossaryTermStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.GlossaryTermStatus.wrap(value))
    override val termRelations
        : Optional[zio.aws.datazone.model.TermRelations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.termRelations())
        .map(value => zio.aws.datazone.model.TermRelations.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateGlossaryTermRequest
  ): zio.aws.datazone.model.CreateGlossaryTermRequest.ReadOnly = new Wrapper(
    impl
  )
}
