package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{
  ProjectId,
  DomainId,
  FormName,
  Description,
  TypeName
}
import scala.jdk.CollectionConverters._
final case class CreateAssetTypeRequest(
    description: Optional[Description] = Optional.Absent,
    domainIdentifier: DomainId,
    formsInput: Map[FormName, zio.aws.datazone.model.FormEntryInput],
    name: TypeName,
    owningProjectIdentifier: ProjectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest = {
    import CreateAssetTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .formsInput(
        formsInput
          .map({ case (key, value) =>
            (FormName.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .name(TypeName.unwrap(name): java.lang.String)
      .owningProjectIdentifier(
        ProjectId.unwrap(owningProjectIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateAssetTypeRequest.ReadOnly =
    zio.aws.datazone.model.CreateAssetTypeRequest.wrap(buildAwsValue())
}
object CreateAssetTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateAssetTypeRequest =
      zio.aws.datazone.model.CreateAssetTypeRequest(
        description.map(value => value),
        domainIdentifier,
        formsInput.map({ case (key, value) =>
          key -> value.asEditable
        }),
        name,
        owningProjectIdentifier
      )
    def description: Optional[Description]
    def domainIdentifier: DomainId
    def formsInput
        : Map[FormName, zio.aws.datazone.model.FormEntryInput.ReadOnly]
    def name: TypeName
    def owningProjectIdentifier: ProjectId
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getFormsInput: ZIO[Any, Nothing, Map[
      FormName,
      zio.aws.datazone.model.FormEntryInput.ReadOnly
    ]] = ZIO.succeed(formsInput)
    def getName: ZIO[Any, Nothing, TypeName] = ZIO.succeed(name)
    def getOwningProjectIdentifier: ZIO[Any, Nothing, ProjectId] =
      ZIO.succeed(owningProjectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest
  ) extends zio.aws.datazone.model.CreateAssetTypeRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val formsInput
        : Map[FormName, zio.aws.datazone.model.FormEntryInput.ReadOnly] = impl
      .formsInput()
      .asScala
      .map({ case (key, value) =>
        zio.aws.datazone.model.primitives
          .FormName(key) -> zio.aws.datazone.model.FormEntryInput.wrap(value)
      })
      .toMap
    override val name: TypeName =
      zio.aws.datazone.model.primitives.TypeName(impl.name())
    override val owningProjectIdentifier: ProjectId =
      zio.aws.datazone.model.primitives
        .ProjectId(impl.owningProjectIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateAssetTypeRequest
  ): zio.aws.datazone.model.CreateAssetTypeRequest.ReadOnly = new Wrapper(impl)
}
