package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{UpdatedAt, DomainId, RoleArn}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateDomainResponse(
    description: Optional[String] = Optional.Absent,
    domainExecutionRole: Optional[RoleArn] = Optional.Absent,
    id: DomainId,
    lastUpdatedAt: Optional[UpdatedAt] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    singleSignOn: Optional[zio.aws.datazone.model.SingleSignOn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.UpdateDomainResponse = {
    import UpdateDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.UpdateDomainResponse
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        domainExecutionRole.map(value =>
          RoleArn.unwrap(value): java.lang.String
        )
      )(_.domainExecutionRole)
      .id(DomainId.unwrap(id): java.lang.String)
      .optionallyWith(
        lastUpdatedAt.map(value => UpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(singleSignOn.map(value => value.buildAwsValue()))(
        _.singleSignOn
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.UpdateDomainResponse.ReadOnly =
    zio.aws.datazone.model.UpdateDomainResponse.wrap(buildAwsValue())
}
object UpdateDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.UpdateDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.UpdateDomainResponse =
      zio.aws.datazone.model.UpdateDomainResponse(
        description.map(value => value),
        domainExecutionRole.map(value => value),
        id,
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        singleSignOn.map(value => value.asEditable)
      )
    def description: Optional[String]
    def domainExecutionRole: Optional[RoleArn]
    def id: DomainId
    def lastUpdatedAt: Optional[UpdatedAt]
    def name: Optional[String]
    def singleSignOn: Optional[zio.aws.datazone.model.SingleSignOn.ReadOnly]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDomainExecutionRole: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("domainExecutionRole", domainExecutionRole)
    def getId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(id)
    def getLastUpdatedAt: ZIO[Any, AwsError, UpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getSingleSignOn
        : ZIO[Any, AwsError, zio.aws.datazone.model.SingleSignOn.ReadOnly] =
      AwsError.unwrapOptionField("singleSignOn", singleSignOn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.UpdateDomainResponse
  ) extends zio.aws.datazone.model.UpdateDomainResponse.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val domainExecutionRole: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.domainExecutionRole())
      .map(value => zio.aws.datazone.model.primitives.RoleArn(value))
    override val id: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.id())
    override val lastUpdatedAt: Optional[UpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.datazone.model.primitives.UpdatedAt(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val singleSignOn
        : Optional[zio.aws.datazone.model.SingleSignOn.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.singleSignOn())
        .map(value => zio.aws.datazone.model.SingleSignOn.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.UpdateDomainResponse
  ): zio.aws.datazone.model.UpdateDomainResponse.ReadOnly = new Wrapper(impl)
}
