package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Resource(
    name: Optional[String] = Optional.Absent,
    provider: Optional[String] = Optional.Absent,
    `type`: String,
    value: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.Resource
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(provider.map(value => value: java.lang.String))(
        _.provider
      )
      .`type`(`type`: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.Resource.ReadOnly =
    zio.aws.datazone.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datazone.model.Resource] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.Resource =
      zio.aws.datazone.model.Resource(
        name.map(value => value),
        provider.map(value => value),
        `type`,
        value
      )
    def name: Optional[String]
    def provider: Optional[String]
    def `type`: String
    def value: String
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getProvider: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("provider", provider)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.Resource
  ) extends zio.aws.datazone.model.Resource.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val provider: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.provider())
      .map(value => value: String)
    override val `type`: String = impl.`type`(): String
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.Resource
  ): zio.aws.datazone.model.Resource.ReadOnly = new Wrapper(impl)
}
